# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # Use these APIs to manage Azure Websites resources through the Azure
  # Resource Manager. All task operations conform to the HTTP/1.1 protocol
  # specification and each operation returns an x-ms-request-id header that
  # can be used to obtain information about the request. You must make sure
  # that requests made to these resources are secure. For more information,
  # see <a
  # href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
  # Azure Resource Manager requests.</a>
  #
  class CertificateOrders
    include Azure::ARM::Web::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CertificateOrders class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Get certificate associated with the certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCertificate] operation results.
    #
    def get_certificate(resource_group_name, certificate_order_name, name, custom_headers = nil)
      response = get_certificate_async(resource_group_name, certificate_order_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get certificate associated with the certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_certificate_with_http_info(resource_group_name, certificate_order_name, name, custom_headers = nil)
      get_certificate_async(resource_group_name, certificate_order_name, name, custom_headers).value!
    end

    #
    # Get certificate associated with the certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_certificate_async(resource_group_name, certificate_order_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'certificate_order_name is nil' if certificate_order_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'certificateOrderName' => certificate_order_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCertificate.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Associates a Key Vault secret to a certificate store that will be used for
    # storing the certificate once it's ready
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param key_vault_certificate [CertificateOrderCertificate] Key Vault secret
    # csm Id
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCertificate] operation results.
    #
    def create_or_update_certificate(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers = nil)
      response = create_or_update_certificate_async(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Associates a Key Vault secret to a certificate store that will be used for
    # storing the certificate once it's ready
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param key_vault_certificate [CertificateOrderCertificate] Key Vault secret
    # csm Id
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_certificate_with_http_info(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers = nil)
      create_or_update_certificate_async(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers).value!
    end

    #
    # Associates a Key Vault secret to a certificate store that will be used for
    # storing the certificate once it's ready
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param key_vault_certificate [CertificateOrderCertificate] Key Vault secret
    # csm Id
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_certificate_async(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'certificate_order_name is nil' if certificate_order_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'key_vault_certificate is nil' if key_vault_certificate.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CertificateOrderCertificate.mapper()
      request_content = @client.serialize(request_mapper,  key_vault_certificate, 'key_vault_certificate')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'certificateOrderName' => certificate_order_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCertificate.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the certificate associated with the certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_certificate(resource_group_name, certificate_order_name, name, custom_headers = nil)
      response = delete_certificate_async(resource_group_name, certificate_order_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes the certificate associated with the certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_certificate_with_http_info(resource_group_name, certificate_order_name, name, custom_headers = nil)
      delete_certificate_async(resource_group_name, certificate_order_name, name, custom_headers).value!
    end

    #
    # Deletes the certificate associated with the certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_certificate_async(resource_group_name, certificate_order_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'certificate_order_name is nil' if certificate_order_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'certificateOrderName' => certificate_order_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Associates a Key Vault secret to a certificate store that will be used for
    # storing the certificate once it's ready
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param key_vault_certificate [CertificateOrderCertificate] Key Vault secret
    # csm Id
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCertificate] operation results.
    #
    def update_certificate(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers = nil)
      response = update_certificate_async(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Associates a Key Vault secret to a certificate store that will be used for
    # storing the certificate once it's ready
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param key_vault_certificate [CertificateOrderCertificate] Key Vault secret
    # csm Id
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_certificate_with_http_info(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers = nil)
      update_certificate_async(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers).value!
    end

    #
    # Associates a Key Vault secret to a certificate store that will be used for
    # storing the certificate once it's ready
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param name [String] Certificate name
    # @param key_vault_certificate [CertificateOrderCertificate] Key Vault secret
    # csm Id
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_certificate_async(resource_group_name, certificate_order_name, name, key_vault_certificate, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'certificate_order_name is nil' if certificate_order_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'key_vault_certificate is nil' if key_vault_certificate.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CertificateOrderCertificate.mapper()
      request_content = @client.serialize(request_mapper,  key_vault_certificate, 'key_vault_certificate')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'certificateOrderName' => certificate_order_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCertificate.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrder] operation results.
    #
    def get_certificate_order(resource_group_name, name, custom_headers = nil)
      response = get_certificate_order_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_certificate_order_with_http_info(resource_group_name, name, custom_headers = nil)
      get_certificate_order_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get a certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_certificate_order_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrder.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a certificate purchase order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param certificate_distinguished_name [CertificateOrder] Distinguished name
    # to be used for purchasing certificate
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrder] operation results.
    #
    def create_or_update_certificate_order(resource_group_name, name, certificate_distinguished_name, custom_headers = nil)
      response = create_or_update_certificate_order_async(resource_group_name, name, certificate_distinguished_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a certificate purchase order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param certificate_distinguished_name [CertificateOrder] Distinguished name
    # to be used for purchasing certificate
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_certificate_order_with_http_info(resource_group_name, name, certificate_distinguished_name, custom_headers = nil)
      create_or_update_certificate_order_async(resource_group_name, name, certificate_distinguished_name, custom_headers).value!
    end

    #
    # Create or update a certificate purchase order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param certificate_distinguished_name [CertificateOrder] Distinguished name
    # to be used for purchasing certificate
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_certificate_order_async(resource_group_name, name, certificate_distinguished_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'certificate_distinguished_name is nil' if certificate_distinguished_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CertificateOrder.mapper()
      request_content = @client.serialize(request_mapper,  certificate_distinguished_name, 'certificate_distinguished_name')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrder.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_certificate_order(resource_group_name, name, custom_headers = nil)
      response = delete_certificate_order_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_certificate_order_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_certificate_order_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Delete an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_certificate_order_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Create or update a certificate purchase order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param certificate_distinguished_name [CertificateOrder] Distinguished name
    # to be used for purchasing certificate
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrder] operation results.
    #
    def update_certificate_order(resource_group_name, name, certificate_distinguished_name, custom_headers = nil)
      response = update_certificate_order_async(resource_group_name, name, certificate_distinguished_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a certificate purchase order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param certificate_distinguished_name [CertificateOrder] Distinguished name
    # to be used for purchasing certificate
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_certificate_order_with_http_info(resource_group_name, name, certificate_distinguished_name, custom_headers = nil)
      update_certificate_order_async(resource_group_name, name, certificate_distinguished_name, custom_headers).value!
    end

    #
    # Create or update a certificate purchase order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param certificate_distinguished_name [CertificateOrder] Distinguished name
    # to be used for purchasing certificate
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_certificate_order_async(resource_group_name, name, certificate_distinguished_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'certificate_distinguished_name is nil' if certificate_distinguished_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CertificateOrder.mapper()
      request_content = @client.serialize(request_mapper,  certificate_distinguished_name, 'certificate_distinguished_name')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrder.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get certificate orders in a resource group
    #
    # @param resource_group_name [String] Azure resource group name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCollection] which provide lazy access to pages of
    # the response.
    #
    def get_certificate_orders_as_lazy(resource_group_name, custom_headers = nil)
      response = get_certificate_orders_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_certificate_orders_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get certificate orders in a resource group
    #
    # @param resource_group_name [String] Azure resource group name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CertificateOrder>] operation results.
    #
    def get_certificate_orders(resource_group_name, custom_headers = nil)
      first_page = get_certificate_orders_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get certificate orders in a resource group
    #
    # @param resource_group_name [String] Azure resource group name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_certificate_orders_with_http_info(resource_group_name, custom_headers = nil)
      get_certificate_orders_async(resource_group_name, custom_headers).value!
    end

    #
    # Get certificate orders in a resource group
    #
    # @param resource_group_name [String] Azure resource group name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_certificate_orders_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCertificateCollection] which provide lazy access to
    # pages of the response.
    #
    def get_certificates_as_lazy(resource_group_name, certificate_order_name, custom_headers = nil)
      response = get_certificates_async(resource_group_name, certificate_order_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_certificates_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CertificateOrderCertificate>] operation results.
    #
    def get_certificates(resource_group_name, certificate_order_name, custom_headers = nil)
      first_page = get_certificates_as_lazy(resource_group_name, certificate_order_name, custom_headers)
      first_page.get_all_items
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_certificates_with_http_info(resource_group_name, certificate_order_name, custom_headers = nil)
      get_certificates_async(resource_group_name, certificate_order_name, custom_headers).value!
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param resource_group_name [String] Azure resource group name
    # @param certificate_order_name [String] Certificate name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_certificates_async(resource_group_name, certificate_order_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'certificate_order_name is nil' if certificate_order_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'certificateOrderName' => certificate_order_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCertificateCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Reissue an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param reissue_certificate_order_request [ReissueCertificateOrderRequest]
    # Reissue parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reissue_certificate_order(resource_group_name, name, reissue_certificate_order_request, custom_headers = nil)
      response = reissue_certificate_order_async(resource_group_name, name, reissue_certificate_order_request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Reissue an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param reissue_certificate_order_request [ReissueCertificateOrderRequest]
    # Reissue parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reissue_certificate_order_with_http_info(resource_group_name, name, reissue_certificate_order_request, custom_headers = nil)
      reissue_certificate_order_async(resource_group_name, name, reissue_certificate_order_request, custom_headers).value!
    end

    #
    # Reissue an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param reissue_certificate_order_request [ReissueCertificateOrderRequest]
    # Reissue parameters
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reissue_certificate_order_async(resource_group_name, name, reissue_certificate_order_request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'reissue_certificate_order_request is nil' if reissue_certificate_order_request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ReissueCertificateOrderRequest.mapper()
      request_content = @client.serialize(request_mapper,  reissue_certificate_order_request, 'reissue_certificate_order_request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/reissue'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Renew an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param renew_certificate_order_request [RenewCertificateOrderRequest] Renew
    # parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def renew_certificate_order(resource_group_name, name, renew_certificate_order_request, custom_headers = nil)
      response = renew_certificate_order_async(resource_group_name, name, renew_certificate_order_request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Renew an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param renew_certificate_order_request [RenewCertificateOrderRequest] Renew
    # parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def renew_certificate_order_with_http_info(resource_group_name, name, renew_certificate_order_request, custom_headers = nil)
      renew_certificate_order_async(resource_group_name, name, renew_certificate_order_request, custom_headers).value!
    end

    #
    # Renew an existing certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate name
    # @param renew_certificate_order_request [RenewCertificateOrderRequest] Renew
    # parameters
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def renew_certificate_order_async(resource_group_name, name, renew_certificate_order_request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'renew_certificate_order_request is nil' if renew_certificate_order_request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RenewCertificateOrderRequest.mapper()
      request_content = @client.serialize(request_mapper,  renew_certificate_order_request, 'renew_certificate_order_request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/renew'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieve the list of certificate actions
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def retrieve_certificate_actions(resource_group_name, name, custom_headers = nil)
      response = retrieve_certificate_actions_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieve the list of certificate actions
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def retrieve_certificate_actions_with_http_info(resource_group_name, name, custom_headers = nil)
      retrieve_certificate_actions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieve the list of certificate actions
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def retrieve_certificate_actions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'CertificateOrderActionElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'CertificateOrderAction'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrive email history
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def retrieve_certificate_email_history(resource_group_name, name, custom_headers = nil)
      response = retrieve_certificate_email_history_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrive email history
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def retrieve_certificate_email_history_with_http_info(resource_group_name, name, custom_headers = nil)
      retrieve_certificate_email_history_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrive email history
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def retrieve_certificate_email_history_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'CertificateEmailElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'CertificateEmail'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resend certificate email
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def resend_certificate_email(resource_group_name, name, custom_headers = nil)
      response = resend_certificate_email_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resend certificate email
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def resend_certificate_email_with_http_info(resource_group_name, name, custom_headers = nil)
      resend_certificate_email_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Resend certificate email
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def resend_certificate_email_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/resendEmail'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Verify domain ownership for this certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def verify_domain_ownership(resource_group_name, name, custom_headers = nil)
      response = verify_domain_ownership_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Verify domain ownership for this certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def verify_domain_ownership_with_http_info(resource_group_name, name, custom_headers = nil)
      verify_domain_ownership_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Verify domain ownership for this certificate order
    #
    # @param resource_group_name [String] Azure resource group name
    # @param name [String] Certificate order name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def verify_domain_ownership_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/verifyDomainOwnership'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get certificate orders in a resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCollection] operation results.
    #
    def get_certificate_orders_next(next_page_link, custom_headers = nil)
      response = get_certificate_orders_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get certificate orders in a resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_certificate_orders_next_with_http_info(next_page_link, custom_headers = nil)
      get_certificate_orders_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get certificate orders in a resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_certificate_orders_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CertificateOrderCertificateCollection] operation results.
    #
    def get_certificates_next(next_page_link, custom_headers = nil)
      response = get_certificates_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_certificates_next_with_http_info(next_page_link, custom_headers = nil)
      get_certificates_next_async(next_page_link, custom_headers).value!
    end

    #
    # List all certificates associated with a certificate order (only one
    # certificate can be associated with an order at a time)
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_certificates_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CertificateOrderCertificateCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
