# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CDN
  #
  # Use these APIs to manage Azure CDN resources through the Azure Resource
  # Manager. You must make sure that requests made to these resources are
  # secure. For more information, see <a
  # href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
  # Azure Resource Manager requests.</a>
  #
  class Endpoints
    include Azure::ARM::CDN::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Endpoints class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [CdnManagementClient] reference to the CdnManagementClient
    attr_reader :client

    #
    # Lists existing CDN endpoints within a profile.
    #
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EndpointListResult] operation results.
    #
    def list_by_profile(profile_name, resource_group_name, custom_headers = nil)
      response = list_by_profile_async(profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists existing CDN endpoints within a profile.
    #
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_profile_with_http_info(profile_name, resource_group_name, custom_headers = nil)
      list_by_profile_async(profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Lists existing CDN endpoints within a profile.
    #
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_profile_async(profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = EndpointListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def get(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = get_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      get_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Gets an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointCreateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def create(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      response = create_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointCreateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_create_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates a new CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointCreateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_create(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      response = begin_create_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointCreateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      begin_create_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Creates a new CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointCreateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'endpoint_properties is nil' if endpoint_properties.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = EndpointCreateParameters.mapper()
      request_content = @client.serialize(request_mapper,  endpoint_properties, 'endpoint_properties')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates an existing CDN endpoint with the specified parameters. Only tags
    # and OriginHostHeader can be updated after creating an endpoint. To update
    # origins, use the Update Origin operation. To update custom domains, use the
    # Update Custom Domain operation.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointUpdateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def update(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      response = update_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointUpdateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_update_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates an existing CDN endpoint with the specified parameters. Only tags
    # and OriginHostHeader can be updated after creating an endpoint. To update
    # origins, use the Update Origin operation. To update custom domains, use the
    # Update Custom Domain operation.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointUpdateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_update(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      response = begin_update_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates an existing CDN endpoint with the specified parameters. Only tags
    # and OriginHostHeader can be updated after creating an endpoint. To update
    # origins, use the Update Origin operation. To update custom domains, use the
    # Update Custom Domain operation.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointUpdateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      begin_update_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Updates an existing CDN endpoint with the specified parameters. Only tags
    # and OriginHostHeader can be updated after creating an endpoint. To update
    # origins, use the Update Origin operation. To update custom domains, use the
    # Update Custom Domain operation.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param endpoint_properties [EndpointUpdateParameters] Endpoint properties
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(endpoint_name, endpoint_properties, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'endpoint_properties is nil' if endpoint_properties.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = EndpointUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  endpoint_properties, 'endpoint_properties')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete_if_exists(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = delete_if_exists_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      nil
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_if_exists_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_delete_if_exists_async(endpoint_name, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete_if_exists(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = begin_delete_if_exists_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      nil
    end

    #
    # Deletes an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_if_exists_with_http_info(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      begin_delete_if_exists_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Deletes an existing CDN endpoint with the specified parameters.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_if_exists_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts an existing stopped CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def start(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = start_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_start_async(endpoint_name, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Starts an existing stopped CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_start(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = begin_start_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts an existing stopped CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      begin_start_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Starts an existing stopped CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def stop(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = stop_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def stop_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_stop_async(endpoint_name, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_stop(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      response = begin_stop_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_stop_with_http_info(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      begin_stop_async(endpoint_name, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_stop_async(endpoint_name, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Forcibly purges CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can describe a file or directory.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def purge_content(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      response = purge_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers).value!
      nil
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can describe a file or directory.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def purge_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_purge_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Forcibly purges CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can describe a file or directory.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_purge_content(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      response = begin_purge_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers).value!
      nil
    end

    #
    # Forcibly purges CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can describe a file or directory.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_purge_content_with_http_info(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      begin_purge_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Forcibly purges CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can describe a file or directory.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_purge_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'content_file_paths is nil' if content_file_paths.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PurgeParameters.mapper()
      request_content = @client.serialize(request_mapper,  content_file_paths, 'content_file_paths')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Forcibly pre-loads CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should describe a file.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def load_content(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      response = load_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers).value!
      nil
    end

    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should describe a file.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def load_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      # Send request
      promise = begin_load_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Forcibly pre-loads CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should describe a file.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_load_content(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      response = begin_load_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers).value!
      nil
    end

    #
    # Forcibly pre-loads CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should describe a file.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_load_content_with_http_info(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      begin_load_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Forcibly pre-loads CDN endpoint content.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should describe a file.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_load_content_async(endpoint_name, content_file_paths, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'content_file_paths is nil' if content_file_paths.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = LoadParameters.mapper()
      request_content = @client.serialize(request_mapper,  content_file_paths, 'content_file_paths')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Validates a custom domain mapping to ensure it maps to the correct CNAME in
    # DNS.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param custom_domain_properties [ValidateCustomDomainInput] Custom domain to
    # validate.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ValidateCustomDomainOutput] operation results.
    #
    def validate_custom_domain(endpoint_name, custom_domain_properties, profile_name, resource_group_name, custom_headers = nil)
      response = validate_custom_domain_async(endpoint_name, custom_domain_properties, profile_name, resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Validates a custom domain mapping to ensure it maps to the correct CNAME in
    # DNS.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param custom_domain_properties [ValidateCustomDomainInput] Custom domain to
    # validate.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def validate_custom_domain_with_http_info(endpoint_name, custom_domain_properties, profile_name, resource_group_name, custom_headers = nil)
      validate_custom_domain_async(endpoint_name, custom_domain_properties, profile_name, resource_group_name, custom_headers).value!
    end

    #
    # Validates a custom domain mapping to ensure it maps to the correct CNAME in
    # DNS.
    #
    # @param endpoint_name [String] Name of the endpoint within the CDN profile.
    # @param custom_domain_properties [ValidateCustomDomainInput] Custom domain to
    # validate.
    # @param profile_name [String] Name of the CDN profile within the resource
    # group.
    # @param resource_group_name [String] Name of the resource group within the
    # Azure subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def validate_custom_domain_async(endpoint_name, custom_domain_properties, profile_name, resource_group_name, custom_headers = nil)
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_properties is nil' if custom_domain_properties.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ValidateCustomDomainInput.mapper()
      request_content = @client.serialize(request_mapper,  custom_domain_properties, 'custom_domain_properties')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/validateCustomDomain'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'endpointName' => endpoint_name,'profileName' => profile_name,'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ValidateCustomDomainOutput.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
