/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2006: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 09/Sep/2006                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/rc_types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

char * progname;

void use(void)
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [-v] [-p pass] new_role_id prog args\n"), progname);
      printf(gettext("This program will set the process rc_role to new_role and then\n"));
      printf(gettext("execute prog via execvp()\n"));
      printf(gettext("-v = verbose\n"));
      printf(gettext("-p pass = use this role password\n"));
    }

int main(int argc, char ** argv)
{
  int res = 0;
  rsbac_rc_role_id_t role;
  int verbose = 0;
  char * pass = NULL;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'h':
                use();
                return 0;
              case 'v':
                verbose++;
                break;
              case 'p':
                if(argc > 2)
                  {
		    pass=argv[2];
                    argc--;
                    argv++;
                  }
                else
                  fprintf(stderr, gettext("%s: missing argument for parameter %c\n"), progname, *pos);
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  if (argc >= 3)
    {
      role=strtol(argv[1],0,10);
      if(verbose)
        printf(gettext("%s: executing %s with role %i\n"),
               progname,argv[2],role);
      res = rsbac_rc_change_role(role, pass);
      error_exit(res);
      res = execvp(argv[2],&argv[2]);
      error_exit(res);
    }
  else
    {
      use();
      return 1;
    }
  return (res);
}

