use strict;
use warnings;

use RT::Test tests => undef;

my ($base, $m) = RT::Test->started_ok;

my $user = RT::Test->load_or_create_user(
    Name        => 'user',
    Password    => 'password',
    Privileged  => 1,
);

ok $user->id, 'created user';

ok(
    RT::Test->set_rights(
        { Principal => 'privileged', Right => [qw(ModifySelf ShowTicket)] },
    ),
    "granted ModifySelf to privileged"
);

my $ticket = RT::Test->create_ticket(
    Queue   => 'General',
    Subject => 'testing',
);

ok $ticket->id, 'created ticket';

$m->login('user');
$m->get_ok("$base/Prefs/Other.html");
my $format = 'Formatters';
$m->submit_form_ok({
    form_name   => 'ModifyPreferences',
    fields      => {
        DateTimeFormat  => $format,
    },
    button      => 'Update',
}, 'update prefs');
is $user->Preferences(RT->System, {})->{DateTimeFormat}, $format, 'set preference';

$m->no_warnings_ok;
$m->get_ok("$base/Ticket/Display.html?id=" . $ticket->id);
$m->next_warning_like(qr/Invalid date formatter.+?\Q$format\E/, 'invalid formatter warning');
$m->content_lacks($_, "lacks formatter in page") for @RT::Date::FORMATTERS;

undef $m;
done_testing;
