# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PoolInformation(Model):
    """Specifies how a job should be assigned to a pool.

    :param pool_id: The id of an existing pool. All the tasks of the job will
     run on the specified pool. You must specify either poolId or
     autoPoolSpecification, but not both.
    :type pool_id: str
    :param auto_pool_specification: Characteristics for a temporary 'auto
     pool'. The Batch service will create this auto pool when the job is
     submitted. You must specify either poolId or autoPoolSpecification, but
     not both.
    :type auto_pool_specification: :class:`AutoPoolSpecification
     <azure.batch.models.AutoPoolSpecification>`
    """ 

    _attribute_map = {
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'auto_pool_specification': {'key': 'autoPoolSpecification', 'type': 'AutoPoolSpecification'},
    }

    def __init__(self, pool_id=None, auto_pool_specification=None):
        self.pool_id = pool_id
        self.auto_pool_specification = auto_pool_specification
