#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011-2012  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filename: textures.c
# Original copyright and license: 2003  John Darrington, GPL3+


from OpenGL import GL as gl
from gtk import gdk

SWATCH_WIDTH  = 256
SWATCH_HEIGHT = 256
SWATCH_WIDTH_SMALL  = 64
SWATCH_HEIGHT_SMALL = 64
SWATCH_WIDTH_SMALLEST = 32
SWATCH_HEIGHT_SMALLEST = 32


class PatternParameters:
    def __init__(self, texName=0, data=[], texFunc=0):
        self.texName = texName  # uint
        self.data = data        # byte[] ?
        self.texFunc = texFunc  # int   This is the function to be passed to glTexEnv


checkImageWidth = 64
checkImageHeight = 64

Image = [[[[0]*4 for __i in xrange(checkImageWidth)]
                    for __j in xrange(checkImageHeight)] for __k in xrange(6)]
xbm = [[0] * (checkImageHeight*checkImageWidth/8) for __i in xrange(6)]

stock_pattern = [PatternParameters() for __i in xrange(6)]


def texMakePatterns ():
    #int i,  j,  c
    k = 0
    x = 0
    shift = 0

    # Stripy pattern 
    for i in xrange(checkImageHeight):
        for j in xrange(checkImageWidth):
            c = ((i&0x04) == 0) * 255
            Image[k][i][j][0] = c
            Image[k][i][j][1] = c
            Image[k][i][j][2] = c
            Image[k][i][j][3] = 255
            xbm[k][x] |= (c&0x01) << shift
            shift += 1
            if shift >= 8:
                shift = 0
                x += 1


    # Diagonal Striped 
    k = 1
    shift = 0
    x = 0
    for i in xrange(checkImageHeight):
        for j in xrange(checkImageWidth):
            c = (((i+j)&0x08) == 0) * 255
            Image[k][i][j][0] = c
            Image[k][i][j][1] = c
            Image[k][i][j][2] = c
            Image[k][i][j][3] = 255
            xbm[k][x] |= (c&0x01) << shift
            shift += 1
            if shift >= 8:
                shift = 0
                x += 1


    # Checked patterns 
    for k in xrange(2, 6):
        mask = 0x01 << k
        shift = 0
        x = 0
        for i in xrange(checkImageHeight):
            for j in xrange(checkImageWidth):
                c = (((i&mask) == 0) ^ ((j&mask) == 0)) * 255
                Image[k][i][j][0] = c
                Image[k][i][j][1] = c
                Image[k][i][j][2] = c
                Image[k][i][j][3] = 255
                xbm[k][x] |= (c&0x01) << shift
                shift += 1
                if shift >= 8:
                    shift = 0
                    x += 1


def texInit ():
    texMakePatterns ()
    gl.glPixelStorei (gl.GL_UNPACK_ALIGNMENT,  1)

    texName = gl.glGenTextures (6)
    #debug(texName)

    gl.glTexEnvi (gl.GL_TEXTURE_ENV,  gl.GL_TEXTURE_ENV_MODE,  gl.GL_MODULATE)
    for i in xrange(6):
        stock_pattern[i].texName = texName[i]

        gl.glBindTexture (gl.GL_TEXTURE_2D,  texName[i])
        gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_WRAP_S,  gl.GL_CLAMP)
        gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_WRAP_T,  gl.GL_CLAMP)
        gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_MAG_FILTER, gl.GL_NEAREST)
        gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_MIN_FILTER, gl.GL_NEAREST)

        gl.glTexImage2D (gl.GL_TEXTURE_2D,  0,  gl.GL_RGBA,  checkImageWidth,
                     checkImageHeight,  0,  gl.GL_RGBA,  gl.GL_UNSIGNED_BYTE,
                     Image[i])

        stock_pattern[i].data = xbm[i]
        stock_pattern[i].texFunc = gl.GL_MODULATE


# Create a texture from a gdk_pixbuf.
# Returns NULL if it cannot be created.
def create_pattern_from_pixbuf (pixbuf):
    gl.glPixelStorei (gl.GL_UNPACK_ALIGNMENT,  1)
    texName = gl.glGenTextures(1)
    #debug('texName',texName)

    gl.glBindTexture (gl.GL_TEXTURE_2D,  texName)
    gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_WRAP_S,  gl.GL_CLAMP)
    gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_WRAP_T,  gl.GL_CLAMP)
    gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_MAG_FILTER, gl.GL_NEAREST)
    gl.glTexParameteri (gl.GL_TEXTURE_2D,  gl.GL_TEXTURE_MIN_FILTER, gl.GL_NEAREST)

    #int width
    #int height
    #guchar * pixels

    #gboolean has_alpha
    #int channels

    #GLenum format
    #GdkColorspace colourSpace

    #domain = g_quark_from_string ("rubik_texture")

    width = pixbuf.get_width ()
    height = pixbuf.get_height ()
    colourSpace =  pixbuf.get_colorspace ()


    channels = pixbuf.get_n_channels ()
    has_alpha = pixbuf.get_has_alpha ()

    # This seems to cover all the cases that gdk_pixbuf
    # supports at the moment 
    if colourSpace == gdk.COLORSPACE_RGB:
        if channels == 4 and has_alpha:
            format_ = gl.GL_RGBA
        elif channels == 3 and not has_alpha:
            format_ = gl.GL_RGB
        else:
            raise Exception(_("Pixbuf has wrong number of channels"))
            #return 0
    else:
        raise Exception(_("Pixbuf has unknown color space: {0}").format(colourSpace))
        #return 0

    pixels = pixbuf.get_pixels ()

    gl.glTexImage2D (gl.GL_TEXTURE_2D, 0, 3,  width,  height, 0,
                 format_,  gl.GL_UNSIGNED_BYTE,  pixels)

    return texName
    
def create_pixbuf_from_file(filename):
    unscaled_pixbuf = gdk.pixbuf_new_from_file(filename)
    
    # We must scale the image,  because Mesa/OpenGL insists on it being of size
    # 2^n ( where n is integer )
    pixbuf = unscaled_pixbuf.scale_simple(SWATCH_WIDTH, SWATCH_HEIGHT, gdk.INTERP_NEAREST)
    return pixbuf
    

