#!/usr/bin/python
#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


import sys, os
import gettext

import pygtk
pygtk.require('2.0')

lib_dir = os.path.dirname(os.path.realpath(__file__))
src_dir, sub_dir = os.path.split(lib_dir)
root_dir = os.path.dirname(os.path.realpath(os.path.dirname(__file__)))

if sub_dir == 'pybiklib':
    sys.path[0] = src_dir
    print 'Running from source directory'
    
try:
    from pybiklib import config
except ImportError:
    print 'Pybik is not properly installed.'
    sys.exit(1)

if sub_dir == 'pybiklib':
    # running from source
    LOCALEDIR = os.path.join(src_dir, 'build', 'mo')
elif root_dir == sys.prefix:
    # normal installation
    LOCALEDIR = None
else:
    # different root, e.g. /usr/local
    LOCALEDIR = config.LOCALE_DIR
gettext.install(config.PACKAGE, LOCALEDIR, names=['ngettext'])

import pybiklib.main


def main():
    pybiklib.main.run()

if __name__ == '__main__':
    main()

