#!/usr/bin/python

"""GTK user interface for pwrkap."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.

import ui_controller
import gtk
import sys
import ui_data
import thread
import gobject

hosts = []
if len(sys.argv) == 1:
	host = ui_data.pwrkap_host("localhost", 9410)
	hosts.append(host)
else:
	for arg in sys.argv[1:]:
		stuff = arg.split(":")
		hostname = stuff[0]
		if len(stuff) == 1:
			port = 9410
		else:
			port = int(stuff[1])
		host = ui_data.pwrkap_host(hostname, port)
		hosts.append(host)

sys.setcheckinterval(10)
gtk.gdk.threads_init()
uc = ui_controller.ui_controller(hosts)
gtk.gdk.threads_enter()
thread.start_new_thread(uc.connect_hosts, ())
gtk.main()
gtk.gdk.threads_leave()
