# Copyright (C) 2005 Maciej Katafiasz
#
# Author: Maciej Katafiasz
#
# This file is part of Purrr programme.
#
# Purrr is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2, or (at your
# option) any later version.
#
# Purrr is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Purrr; see the file COPYING. If not, write to the
# Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

import re

class FileMatcher:
    def __init__(self):

        self.filters = [ { "filter" : "^[.].*$", "name" : "dot",
                           "description" : "Dot files", "enabled" : True},
                         
                         { "filter" : "^.*~$|^.*\\.bak", "name" : "backup",
                           "description" : "Backup files", "enabled" : False},
                         
                         { "filter" : "^#.*#$", "name" : "autosave",
                           "description" : "Autosave files", "enabled" : True} ]

        self.__construct_rx()

    def __construct_rx(self):
        rx = ""
        for r in self.filters:
            if r["enabled"]:
                rx += r["filter"] + "|"
        rx = rx.rstrip("|")
        rx = rx or "^$"
        self.rx = re.compile(rx)

    def match(self, name):
        return self.rx.match(name)

    def add_filter(self, filter, name, description = None, enabled = False):
        self.filters.append({"filter" : filter, "name" : name,
                             "description" : description, "enabled" : enabled})
        self.__construct_rx()

    def enable_filter(self, name, enable = True):
        for f in self.filters:
            if f["name"] == name: f["enabled"] = enable
        self.__construct_rx()
