use strict;
use warnings;

use Test::More tests => 5;
use File::pushd;
use Cwd qw(abs_path);

#BEGIN {
#use_ok( 'Publican::XmlClean' );
#}

diag("Testing bin/publican on the Users_Guide");

my $common_content = abs_path('blib/datadir/Common_Content');
my $common_config  = abs_path('blib/datadir');
my $cover_db       = undef;
my $coverdb        = '';
if ( -d 'cover_db' ) {
    $cover_db = abs_path('cover_db');
    $coverdb  = qq|-MDevel::Cover=-db,$cover_db|;
}
my $lib         = abs_path('blib/lib');
my $publican    = abs_path('blib/script/publican');
my @common_opts = [ '--common_config', $common_config, '--common_content',
    $common_content ];

my $dir = pushd('Users_Guide');
my $result;

## is(system('perl -I ../blib/lib ../blib/script/publican old2new'), 0, 'Run old2new');
$result = system( 'perl', '-CA', '-I', $lib, $publican, 'print_tree',
    @common_opts );
diag("result 1 = $result\n");
is( $result, 0, 'Run print_tree' );

$result = system( 'perl', '-CA', '-I', $lib, $publican, 'update_pot',
    @common_opts );
diag("\nresult 2 = $result\n");
is( $result, 0, 'Update POT file' );

# TODO rebuild all translation when we get some
$result = system(
    'perl',      '-CA',     '-I',    $lib, $publican,
    'update_po', '--langs', 'de-DE', @common_opts
);
diag("\nresult 3 = $result\n");

is( $result, 0, 'Update German PO files' );

## BUGBUG why doesn't the test system see these tests being run?
$result = system(
    'perl',      '-CA',  '-I',      $lib,    $publican, 'build',
    '--formats', 'html', '--langs', 'de-DE', @common_opts
);
diag("\nresult 4 = $result\n");

is( $result, 0, 'build the Users Guide' );

$result = system(
    'perl',      '-CA',
    '-I',        $lib,
    $publican,   'build',
    '--formats', 'html,html-single,html-desktop,pdf,txt,eclipse,epub',
    '--langs',   'en-US',
    @common_opts
);
diag("\nresult 5 = $result\n");

is( $result, 0, 'build the Users Guide in all formats' );

$dir = undef;

