/* $Cambridge: hermes/src/prayer/cmd/cmd_zoom.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_zoom(struct session *session)
{
    struct request *request = session->request;

    if (msgmap_have_zoom(session->zm)) {
        session_message(session, "Zoom mode disabled");
        msgmap_disable_zoom(session->zm);
    } else {
        if (msgmap_marked_count(session->zm) > 0) {
            msgmap_enable_zoom(session->zm);
            session_message(session, "Zoom mode enabled");
        } else
            session_message(session,
                            "Zoom mode not enabled (no messages marked)");
    }

    session_redirect(session, request, "list");
}
