/***************************************************************************
 *   Copyright (C) 2009 by Mathias Rabe <masterunderlined [at] web.de>     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
#ifndef DROP2FTP_H
#define DROP2FTP_H

#include <QGraphicsLinearLayout>
#include <QStandardItemModel>

#include <KIcon>
#include <KDE/KIO/Job>
#include <kbookmarkmanager.h>
 
#include <Plasma/Applet>
#include <plasma/widgets/iconwidget.h>
#include <plasma/widgets/label.h>

#include "bookmarktraverser.h"

#include "ui_drop2ftpConfigAppearance.h"
#include "ui_drop2ftpConfigDestination.h"
#include "ui_drop2ftpConfigBehavior.h"


namespace Plasma
{
    class Icon;
}


class Drop2FTP : public Plasma::Applet
{
    Q_OBJECT
    public:
        Drop2FTP(QObject *parent, const QVariantList &args);
        ~Drop2FTP();
        void init();
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
        enum defaultAction {
            CopyFiles,
            MoveFiles,
            AskForFiles
        };

    public slots:
        void configAccepted();
        void openIconDialog();
        void addBookmarkGroup(QString icon, QString text);
        void addBookmark(QString icon, QString text, KUrl url);
        void leaveBookmarkGroup();
        void copyBookmarkAddress(const QModelIndex &index);
        void traverseBookmarks(const QString &groupAddress, const QString &caller);

    private slots:
        void slotResult(KJob *job);
        void openFileDialog();
        void resetIcon();
        void openDestination();

    protected:
        void sendToServer(KUrl::List &src);
        void copyToServer(const KUrl::List src, const KUrl &dest);
        void moveToServer(const KUrl::List src, const KUrl &dest);
        void dragEnterEvent(QGraphicsSceneDragDropEvent *event);
        void dropEvent(QGraphicsSceneDragDropEvent *event);
        void createConfigurationInterface(KConfigDialog *parent);
        void traverseBookmarks();
        QList<QAction*> contextualActions();

    private:
        QGraphicsLinearLayout *layout;
        Ui::drop2ftpConfigAppearance uiAppear;
        Ui::drop2ftpConfigDestination uiDest;
        Ui::drop2ftpConfigBehavior uiBehav;
        QString m_serverAddress; 
        QString m_serverTitle;
        bool m_useBrowserOnClick;
        bool m_generateLinks;
        QString m_protocol4Links;
        int m_defaultAction;
        int m_numActivJobs;
        QString m_newIcon;
        QString m_iconName;
        QString m_syntax4Links;
        Plasma::IconWidget *m_icon;
        Plasma::Label *m_label;
        QStandardItemModel *model;
        QStandardItem *parentItem;
        KBookmarkManager* bookmarkManager;
        BookmarkTraverser *traverser;
        QList<QAction*> m_actions;
};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(drop2ftp, Drop2FTP)
#endif
