/***************************************************************************
 *            qof-invoice.c
 *
 *  Sat 22 Nov 2008 23:02:03 GMT
 *  Copyright  2008  Neil Williams  <linux@codehelp.co.uk>
 ****************************************************************************/
 /*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PILOT_INVOICE_H
#define _PILOT_INVOICE_H

#define INVOICE_MOD     "invoice-debug"

#define PILOT_INVOICE   "pilot_invoice"
#define INV_DATE        "invoice_date"
#define PAY_DATE        "payment_date"
#define INV_REFERENCE   "invoice_reference"
#define INV_DESCRIPTION "invoice_description"
#define INV_CURRENCY    "currency_code"
#define INV_AMOUNT      "invoice_amount"
#define INV_NOTE        "invoice_note"
#define INV_CATEGORY    "category"
#define INV_VENDOR      "invoice_vendor"
#define INV_CITY        "invoice_city"
#define INV_KVP         "currency_lookup"
#define INV_DATES       "pilot_datebook"
#define INV_ADDR        "pilot_address"
#define INV_EXPENSE     "pilot_expenses"

/** type:  KVP_TYPE_STRING */
#define INV_CURRENCY_MNEMONIC "invoice/currency/mnemonic"
/** type:  KVP_TYPE_STRING */
#define INV_CURRENCY_SYMBOL   "invoice/currency/symbol"
/** type:  KVP_TYPE_GINT64 */
#define INV_CURRENCY_FRACTION "invoice/currency/fraction"

/** Expense Preferences identifier. */
#define INV_EXPENSE_PREF Invoice_Pref

/** \brief Register this object with QOF
*/
gboolean InvoiceRegister (void);

#endif /* _PILOT_INVOICE_H */
