<?php

/**
* Does everything relevant to drawing or filling ellipses, lines, or rectangles
*
* @version 0.3
* @author  Matt McClanahan <cardinal@dodds.net>
* @package Imlib
* @access public
*/
class ImlibDraw extends ImlibCliprect
{
   /**
   * Resource id# of the image to draw on
   *
   * @access private
   */
   var $im;

   /**
   * ImlibDraw constructor
   *
   * @access public
   */
   function ImlibDraw()
   {
      $this->cliprect = 0;
      $this->cliprect_inuse = 0;
      $this->color = 0;
      $this->im = 0;
   }

   /**
   * Callback for drawing everything
   *
   * Since all the drawing functions work the same way, this function
   * does all the work.  It takes four ints, often x,y,w,h, and passes
   * them to the specified function.
   *
   * @param int First param
   * @param int Second param
   * @param int Third param
   * @param int Fourth param
   * @param string The name of the function to call
   * @return bool False if no image is set yet
   * @access private
   */
   function _draw_something($x,$y,$w,$h,$cb)
   {
      if (!is_resource($this->im))
         return false;

      if (!$this->get_color($r,$g,$b,$a))
         list($r,$g,$b,$a) = Array(255,255,255,255);

      $cbname = 'imlib_image_' . $cb;

      if ($this->cliprect_inuse)
         return $cbname($this->im,$x,$y,$w,$h,$r,$g,$b,$a,
                        $this->get_cliprect_array());
      else
         return $cbname($this->im,$x,$y,$w,$h,$r,$g,$b,$a);
   }

   /**
   * Draw an ellipse
   *
   * @param int Center X coordinate
   * @param int Center Y coordinate
   * @param int Ellipse horizontal amplitude
   * @param int Ellipse vertical amplitude
   *
   * @return bool False if no image is set yet
   * @access public
   */
   function draw_ellipse($x,$y,$w,$h)
   {
      return $this->_draw_something($x,$y,$w,$h,'draw_ellipse');
   }

   /**
   * Draw a line
   *
   * @param int First X coordinate
   * @param int First Y coordinate
   * @param int Second X coordinate
   * @param int Second Y coordinate
   *
   * @return bool False if no image is set yet
   * @access public
   */
   function draw_line($x1,$y1,$x2,$y2)
   {
      return $this->_draw_something($x1,$y1,$x2,$y2,'draw_line');
   }

   /**
   * Draw a rectangle
   *
   * @param int Upper left X coordinate
   * @param int Upper left Y coordinate
   * @param int Width
   * @param int Height
   *
   * @return bool False if no image is set yet
   * @access public
   */
   function draw_rectangle($x,$y,$w,$h)
   {
      return $this->_draw_something($x,$y,$w,$h,'draw_rectangle');
   }

   /**
   * Fill an ellipse
   *
   * @param int Center X coordinate
   * @param int Center Y coordinate
   * @param int Ellipse horizontal amplitude
   * @param int Ellipse vertical amplitude
   *
   * @return bool False if no image is set yet
   * @access public
   */
   function fill_ellipse($x,$y,$w,$h)
   {
      return $this->_draw_something($x,$y,$w,$h,'fill_ellipse');
   }

   /**
   * Fill a rectangle
   *
   * @param int Upper left X coordinate
   * @param int Upper left Y coordinate
   * @param int Width
   * @param int Height
   *
   * @return bool False if no image is set yet
   * @access public
   */
   function fill_rectangle($x,$y,$w,$h)
   {
      return $this->_draw_something($x,$y,$w,$h,'fill_rectangle');
   }

   /**
   * Get the current image resource id#
   *
   * @access public
   */
   function get_image()
   {
      return $this->im;
   }

   /**
   * Set the image resource id# to draw on
   *
   * @param int Image resource id#
   * @access public
   */
   function set_image($im)
   {
      $this->im = $im;
   }
};

?>
