/***************************************************************************
                          phasescope.cpp  -  description
                             -------------------
    begin                : Sun Sep 19 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <stdio.h>

#include "phasescope.h"

#include <qpainter.h>
#include <qpixmap.h>

PhaseScope::PhaseScope( QWidget *parent, const char *name )
          : QWidget( parent, name )

{
  	//p = new QPainter;
    //tmp = new QPainter;

  	//setBackgroundColor( QColor( 0, 0, 55) );
    //repaint();

}

PhaseScope::~PhaseScope(){
}

void PhaseScope::paintEvent( QPaintEvent *e )
{
    static QPen     pen1( QColor( 0, 0, 70 ), 1 );
    static QPen     pen2( red, 3 );
    static QPen     pen3( yellow, 3 );
    static QPen     pen4( cyan, 3 );
    static QPen     pen5( QColor( 30, 44, 255 ), 1 );
    static QPen     pen6( QColor( 55, 55, 55 ), 1 );

    QPainter p, tmp;

    static QRect    r = e->rect();
    r.setWidth( r.width() - 2 );
    r.setHeight( r.height() - 2 );

    static QPixmap  pix( r.size());
    pix.setOptimization( QPixmap::BestOptim );
	
    pix.fill( this, r.topLeft() );
    //pix.fill( QColor( 0, 0, 55) );

    static   int firstTime = 1;

    int x, y;    // target coordinates for the scope vector
  	int cx, cy;  // coordinates of the center of the scope
  	static int px, py; // previous coordinates

  	static float fudge =  2.0 * M_PI / 256.0;
  	float theta;

  	cx = 57;
  	cy = 57;
  	
    tmp.begin( &pix );
    tmp.setBrush( QBrush(QColor( 0, 0, 70) ));
  	//tmp.setBackgroundColor( QColor( 0, 0, 55) );
  	if ( firstTime )
    {
        firstTime = 0;
	  	px = cx;
        py = cy;
    }

  	theta = phdelta * fudge;

  	x = (int)rint(cx + amplitude * cos( theta + M_PI_2 ));
  	y = (int)rint(cy - amplitude * sin( theta + M_PI_2 ));

  	// Draw the circle on the phase scope
    //tmp.setPen( pen6 );
    //tmp.drawArc( 4,4, 107,107, 0, 360*16 );
    tmp.setPen( pen1 );
    tmp.drawPie( 4,4, 107,107, 0, 360*16 );

    // Draw scale
  	//tmp.setPen( pen5 );
  	//tmp.drawLine( 4, 57, 111, 57 );
  	//tmp.drawLine( 57, 4, 57, 111 );
    //tmp.drawArc( 15,15, 84,84, 0, 360*16 );
  	
  	// Draw new vector
  	if ( dcd ) tmp.setPen( pen3 );
  	else if ( tx ) tmp.setPen( pen4 );
  	else tmp.setPen( pen2 );  	
  	
  	tmp.drawLine( cx, cy, x, y );

    tmp.end();

  	// save coordinates
  	px = x;
  	py = y;
  	
  	QPoint point = r.topLeft();
    point.setX( point.x() + 1 );
    point.setY( point.y() + 1 );
  	
    p.begin( this );
	p.drawPixmap( point, pix );
	p.end();

}	

void PhaseScope::plot( void )
{
	if ( amplitude > 50 ) amplitude = 50;
	else if ( amplitude <  2 ) amplitude = 2;

	repaint( FALSE );
}

/**  */
void PhaseScope::plotPhase( int _phase )
{
    amplitude = 50;
    phdelta = _phase;
    tx = 1;
    dcd = 0;
    plot();
}
