#!perl

use LWP::Online ':skip_all';
use Test::Most tests => 2;
use Path::Class;

use App::Parcimonie;

my $nonexistent_keyid = 'A'x40;
my $existent_keyid    = '6F818B215E159EF3FA26B0BE624DC565135EA668';
my $gnupg_options     = { homedir => dir('t', 'data', 'gnupg_homedir') };

$ENV{LC_ALL} = 'C';

use Env qw{@PATH};
use FindBin;
unshift @PATH, "$FindBin::Bin/../bin";

dies_ok { gpgRecvKeys([ $nonexistent_keyid ], $gnupg_options) }
    "gpgRecvKeys throws an exception when trying to receive a non-existing key.";

like(
    gpgRecvKeys([ $existent_keyid ], $gnupg_options),
    '/gpg: \s+ Total\snumber\sprocessed: \s+ 1\n
gpg: \s+ (?:unchanged|new\s+signatures) : \s+ /xms',
    "gpgRecvKeys returns an expected string when receiving an existing key."
);
