// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Select3D_Projector_HeaderFile
#define _Select3D_Projector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Select3D_Projector_HeaderFile
#include <Handle_Select3D_Projector.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _gp_GTrsf_HeaderFile
#include <gp_GTrsf.hxx>
#endif
#ifndef _gp_Vec2d_HeaderFile
#include <gp_Vec2d.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _Standard_Transient_HeaderFile
#include <Standard_Transient.hxx>
#endif
class V3d_View;
class Standard_NoSuchObject;
class gp_Ax2;
class gp_Trsf;
class gp_Vec2d;
class gp_GTrsf;
class gp_Vec;
class gp_Pnt;
class gp_Pnt2d;
class Bnd_Box;
class gp_Lin;


//! A framework to define 3D projectors. <br>
class Select3D_Projector : public Standard_Transient {

public:

  //! Constructs the 3D projector object defined by the 3D view aView. <br>
  Standard_EXPORT   Select3D_Projector(const Handle(V3d_View)& aView);
  
  Standard_EXPORT   Select3D_Projector();
  //! Creates   an axonometric  projector.   <CS> is the <br>
//!          viewing coordinate system. <br>
  Standard_EXPORT   Select3D_Projector(const gp_Ax2& CS);
  //! Creates  a  perspective  projector.   <CS>  is the <br>
//!          viewing coordinate system. <br>
  Standard_EXPORT   Select3D_Projector(const gp_Ax2& CS,const Standard_Real Focus);
  //! build a Projector with automatic minmax directions. <br>
  Standard_EXPORT   Select3D_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus);
  //! build a Projector with given minmax directions. <br>
  Standard_EXPORT   Select3D_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus,const gp_Vec2d& v1,const gp_Vec2d& v2,const gp_Vec2d& v3);
  //! build a Projector with automatic minmax directions. <br>
  Standard_EXPORT   Select3D_Projector(const gp_GTrsf& GT,const Standard_Boolean Persp,const Standard_Real Focus);
  
  Standard_EXPORT     void Set(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus) ;
  //! Sets the 3D view V used at the time of construction. <br>
  Standard_EXPORT     void SetView(const Handle(V3d_View)& V) ;
  //! Returns the 3D view used at the time of construction. <br>
       const Handle_V3d_View& View() const;
  
      virtual  void Directions(gp_Vec2d& D1,gp_Vec2d& D2,gp_Vec2d& D3) const;
  //! to compute with the given scale and translation. <br>
  Standard_EXPORT   virtual  void Scaled(const Standard_Boolean On = Standard_False) ;
  //! Returns True if there is a perspective transformation. <br>
      virtual  Standard_Boolean Perspective() const;
  //! Returns the active transformation. <br>
      virtual const gp_GTrsf& Transformation() const;
  //! Returns the active inverted transformation. <br>
      virtual const gp_GTrsf& InvertedTransformation() const;
  //! Returns the original transformation. <br>
      virtual const gp_Trsf& FullTransformation() const;
  //! Returns the focal length. <br>
      virtual  Standard_Real Focus() const;
  
      virtual  void Transform(gp_Vec& D) const;
  
      virtual  void Transform(gp_Pnt& Pnt) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT   virtual  void Project(const gp_Pnt& P,gp_Pnt2d& Pout) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT     void Project(const gp_Pnt& P,Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT   virtual  void Project(const gp_Pnt& P,const gp_Vec& D1,gp_Pnt2d& Pout,gp_Vec2d& D1out) const;
  //! Adds to the box <B> the min-max of the point <P>. <br>
  Standard_EXPORT   virtual  void BoxAdd(const gp_Pnt2d& P,Bnd_Box& B) const;
  //! return a line going through the eye towards the <br>
//!          2d point <X,Y>. <br>
  Standard_EXPORT   virtual  gp_Lin Shoot(const Standard_Real X,const Standard_Real Y) const;
  //! Returns the minimum depth value (if clipping plane defined). <br>
//!         Should be used when call ::Shoot() to compute eyeline. <br>
        Standard_Real DepthMin() const;
  //! Returns the maximum depth value (if clipping plane defined). <br>
//!         Should be used when call ::Shoot() to compute eyeline. <br>
        Standard_Real DepthMax() const;
  //! Setup the min/max depth values (doesn't affect <br>
//!         projection functionality itself). <br>
//!         Should be used when call ::Shoot() to compute eyeline. <br>
  Standard_EXPORT     void DepthMinMax(const Standard_Real theDepthMin,const Standard_Real theDepthMax) ;
  
      virtual  void Transform(gp_Pnt& P,const gp_GTrsf& T) const;
  
      virtual  void Transform(gp_Lin& D,const gp_GTrsf& T) const;




  DEFINE_STANDARD_RTTI(Select3D_Projector)

protected:


Standard_Boolean myPersp;
Standard_Real myFocus;
gp_Trsf myScaledTrsf;
gp_GTrsf myGTrsf;
gp_GTrsf myInvTrsf;
gp_Vec2d myD1;
gp_Vec2d myD2;
gp_Vec2d myD3;


private: 

  
  Standard_EXPORT     void SetDirection() ;

Standard_Integer myType;
Handle_V3d_View myView;
Standard_Real myDepthMin;
Standard_Real myDepthMax;


};


#include <Select3D_Projector.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
