// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_Process_HeaderFile
#define _OSD_Process_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class OSD_OSDError;
class TCollection_AsciiString;
class Quantity_Date;
class OSD_Path;


//! A set of system process tools <br>
class OSD_Process  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Initializes the object and prepare for a possible dump <br>
  Standard_EXPORT   OSD_Process();
  //! Issues a shell command <br>
//! ShowWindow : flag to allow show/hide of the window ( only used on WNT ) <br>
  Standard_EXPORT     void Spawn(const TCollection_AsciiString& cmd,const Standard_Boolean ShowWindow = Standard_True) ;
  //! Returns the terminal used (vt100, vt200 ,sun-cmd ...) <br>
  Standard_EXPORT     void TerminalType(TCollection_AsciiString& Name) ;
  //! Gets system date. <br>
  Standard_EXPORT     Quantity_Date SystemDate() ;
  //! Returns the 'User Id'. <br>
  Standard_EXPORT     Standard_Integer UserId() ;
  //! Returns the user name. <br>
  Standard_EXPORT     TCollection_AsciiString UserName() ;
  //! Returns True if the process user is the super-user. <br>
  Standard_EXPORT     Standard_Boolean IsSuperUser() ;
  //! Returns the 'Process Id' <br>
  Standard_EXPORT     Standard_Integer ProcessId() ;
  //! Returns the current path where the process is. <br>
  Standard_EXPORT     OSD_Path CurrentDirectory() ;
  //! Changes the current process directory. <br>
  Standard_EXPORT     void SetCurrentDirectory(const OSD_Path& where) ;
  //! Returns TRUE if an error occurs <br>
  Standard_EXPORT     Standard_Boolean Failed() const;
  //! Resets error counter to zero <br>
  Standard_EXPORT     void Reset() ;
  //! Raises OSD_Error <br>
  Standard_EXPORT     void Perror() ;
  //! Returns error number if 'Failed' is TRUE. <br>
  Standard_EXPORT     Standard_Integer Error() const;





protected:





private:



OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
