// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_STAT_HeaderFile
#define _Interface_STAT_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfAsciiString.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfReal_HeaderFile
#include <Handle_TColStd_HSequenceOfReal.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TCollection_HAsciiString;
class TColStd_HSequenceOfAsciiString;
class TColStd_HSequenceOfReal;
class TColStd_HSequenceOfInteger;


//! This class manages statistics to be queried asynchronously. <br>
//!           Way of use : <br>
//!           An operator describes a STAT form then fills it according to <br>
//!           its progression. This produces a state of advancement of the <br>
//!           process. This state can then be queried asynchronously : <br>
//!           typically it is summarised as a percentage. There are also <br>
//!           an identification of the current state, and informations on <br>
//!           processed volume. <br>
//! <br>
//!           A STAT form can be described once for all (as static). <br>
//!           It describes the stream of the process (see later), in terms <br>
//!           of phases, cycles, steps, with estimated weights. But it <br>
//!           brings no current data. <br>
//! <br>
//!           One STAT at a time is active for filling and querying. It is <br>
//!           used to control phasing, weighting ... Specific data for <br>
//!           execution are given when running on active STAT : counts of <br>
//!           items ... Data for query are then recorded and can be accessed <br>
//!           at any time, asynchronously. <br>
//! <br>
//!           A STAT is organised as follows : <br>
//!           - it can be split into PHASES (by default, there is none, and <br>
//!             all process takes place in one "default" phase) <br>
//!           - each phase is identified by a name and is attached a weight <br>
//!           -> the sum of the weights is used to compute relative weights <br>
//!           - for each phase, or for the unique default phase if none : <br>
//!           -- the process works on a list of ITEMS <br>
//!           -- by default, all the items are processed in once <br>
//!           -- but this list can be split into CYCLES, each one takes <br>
//!              a sub-list : the weight of each cycle is related to its <br>
//!              count of items <br>
//!           -- a cycle can be split into STEPS, by default there are none <br>
//!              then one "default step" is considered <br>
//!           -- each step is attached a weight <br>
//!           -> the sum of the weights of steps is used to compute relative <br>
//!              weights of the steps in each cycle <br>
//!           -> all the cycles of a phase have the same organisation <br>
//! <br>
//!           Hence, when defining the STAT form, the phases have to be <br>
//!           described. If no weight is precisely known, give 1. for all... <br>
//!           No phase description will give only one "default" phase <br>
//!           For each phase, a typical cycle can be described by its steps. <br>
//!           Here too, for no weight precisely known, give 1. for all... <br>
//! <br>
//!           For executing, activate a STAT to begin count. Give counts of <br>
//!           items and cycles for the first phase (for the unique default <br>
//!           one if no phasing is described) <br>
//!           Else, give count of items and cycles for each new phase. <br>
//!           Class methods allow also to set next cycle (given count of <br>
//!           items), next step in cycle (if more then one), next item in <br>
//!           step. <br>
class Interface_STAT  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates a STAT form. At start, one default phase is defined, <br>
//!           with one default step. Then, it suffises to start with a <br>
//!           count of items (and cycles if several) then record items, <br>
//!           to have a queryable report. <br>
  Standard_EXPORT   Interface_STAT(const Standard_CString title = "");
  //! used when starting <br>
  Standard_EXPORT   Interface_STAT(const Interface_STAT& other);
  //! Returns fields in once, without copying them, used for copy <br>
//!           when starting <br>
  Standard_EXPORT     void Internals(Handle(TCollection_HAsciiString)& tit,Standard_Real& total,Handle(TColStd_HSequenceOfAsciiString)& phn,Handle(TColStd_HSequenceOfReal)& phw,Handle(TColStd_HSequenceOfInteger)& phdeb,Handle(TColStd_HSequenceOfInteger)& phfin,Handle(TColStd_HSequenceOfReal)& stw) const;
  //! Adds a new phase to the description. <br>
//!           The first one after Create replaces the default unique one <br>
  Standard_EXPORT     void AddPhase(const Standard_Real weight,const Standard_CString name = "") ;
  //! Adds a new step for the last added phase, the default unique <br>
//!           one if no AddPhase has already been added <br>
//!  Warning : AddStep before the first AddPhase are cancelled <br>
  Standard_EXPORT     void AddStep(const Standard_Real weight = 1) ;
  //! Returns global description (cumulated weights of all phases, <br>
//!           count of phases,1 for default, and title) <br>
  Standard_EXPORT     void Description(Standard_Integer& nbphases,Standard_Real& total,Standard_CString& title) const;
  //! Returns description of a phase, given its rank <br>
//!           (n0 for first step, count of steps, default gives one; <br>
//!            weight, name) <br>
  Standard_EXPORT     void Phase(const Standard_Integer num,Standard_Integer& n0step,Standard_Integer& nbstep,Standard_Real& weight,Standard_CString& name) const;
  //! Returns weight of a Step, related to the cumul given for the <br>
//!           phase. <br>
//!           <num> is given by <n0step> + i, i between 1 and <nbsteps> <br>
//!           (default gives n0step < 0 then weight is one) <br>
  Standard_EXPORT     Standard_Real Step(const Standard_Integer num) const;
  //! Starts a STAT on its first phase (or its default one) <br>
//!           <items> gives the total count of items, <cycles> the count of <br>
//!           cycles <br>
//!           If <cycles> is more than one, the first Cycle must then be <br>
//!           started by NextCycle (NextStep/NextItem are ignored). <br>
//!           If it is one, NextItem/NextStep can then be called <br>
  Standard_EXPORT     void Start(const Standard_Integer items,const Standard_Integer cycles = 1) const;
  //! Starts a default STAT, with no phase, no step, ready to just <br>
//!           count items. <br>
//!           <items> gives the total count of items <br>
//!           Hence, NextItem is available to directly count <br>
  Standard_EXPORT   static  void StartCount(const Standard_Integer items,const Standard_CString title = "") ;
  //! Commands to resume the preceeding phase and start a new one <br>
//!           <items> and <cycles> as for Start, but for this new phase <br>
//!           Ignored if count of phases is already passed <br>
//!           If <cycles> is more than one, the first Cycle must then be <br>
//!           started by NextCycle (NextStep/NextItem are ignored). <br>
//!           If it is one, NextItem/NextStep can then be called <br>
  Standard_EXPORT   static  void NextPhase(const Standard_Integer items,const Standard_Integer cycles = 1) ;
  //! Changes the parameters of the phase to start <br>
//!           To be used before first counting (i.e. just after NextPhase) <br>
//!           Can be used by an operator which has to reajust counts on run <br>
  Standard_EXPORT   static  void SetPhase(const Standard_Integer items,const Standard_Integer cycles = 1) ;
  //! Commands to resume the preceeding cycle and start a new one, <br>
//!           with a count of items <br>
//!           Ignored if count of cycles is already passed <br>
//!           Then, first step is started (or default one) <br>
//!           NextItem can be called for the first step, or NextStep to pass <br>
//!           to the next one <br>
  Standard_EXPORT   static  void NextCycle(const Standard_Integer items) ;
  //! Commands to resume the preceeding step of the cycle <br>
//!           Ignored if count of steps is already passed <br>
//!           NextItem can be called for this step, NextStep passes to next <br>
  Standard_EXPORT   static  void NextStep() ;
  //! Commands to add an item in the current step of the current <br>
//!           cycle of the current phase <br>
//!           By default, one item per call, can be overpassed <br>
//!           Ignored if count of items of this cycle is already passed <br>
  Standard_EXPORT   static  void NextItem(const Standard_Integer nbitems = 1) ;
  //! Commands to declare the process ended (hence, advancement is <br>
//!           forced to 100 %) <br>
  Standard_EXPORT   static  void End() ;
  //! Returns an identification of the STAT : <br>
//!           <phase> True (D) : the name of the current phase <br>
//!           <phase> False : the title of the current STAT <br>
  Standard_EXPORT   static  Standard_CString Where(const Standard_Boolean phase = Standard_True) ;
  //! Returns the advancement as a percentage : <br>
//!           <phase> True : inside the current phase <br>
//!           <phase> False (D) : relative to the whole process <br>
  Standard_EXPORT   static  Standard_Integer Percent(const Standard_Boolean phase = Standard_False) ;





protected:





private:



Handle_TCollection_HAsciiString thetitle;
Standard_Real thetotal;
Handle_TColStd_HSequenceOfAsciiString thephnam;
Handle_TColStd_HSequenceOfReal thephw;
Handle_TColStd_HSequenceOfInteger thephdeb;
Handle_TColStd_HSequenceOfInteger thephfin;
Handle_TColStd_HSequenceOfReal thestw;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
