// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntAna_QuadQuadGeo_HeaderFile
#define _IntAna_QuadQuadGeo_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IntAna_ResultType_HeaderFile
#include <IntAna_ResultType.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class Standard_DomainError;
class Standard_OutOfRange;
class gp_Pln;
class gp_Cylinder;
class gp_Sphere;
class gp_Cone;
class gp_Pnt;
class gp_Lin;
class gp_Circ;
class gp_Elips;
class gp_Parab;
class gp_Hypr;


//! Geometric intersections between two natural quadrics <br>
//!          (Sphere , Cylinder , Cone , Pln from gp). <br>
//!          The possible intersections are : <br>
//!           - 1 point <br>
//!           - 1 or 2 line(s) <br>
//!           - 1 Point and 1 Line <br>
//!           - 1 circle <br>
//!           - 1 ellipse <br>
//!           - 1 parabola <br>
//!           - 1 or 2 hyperbola(s). <br>
//!           - Empty : there is no intersection between the two quadrics. <br>
//!           - Same  : the quadrics are identical <br>
//!           - NoGeometricSolution : there may be an intersection, but it <br>
//!                is necessary to use an analytic algorithm to determine <br>
//!                it. See class IntQuadQuad from IntAna. <br>
class IntAna_QuadQuadGeo  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Empty constructor. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo();
  //! Creates the intersection between two planes. <br>
//!          TolAng is the angular tolerance used to determine <br>
//!          if the planes are parallel. <br>
//!          Tol is the tolerance used to determine if the planes <br>
//!          are identical (only when they are parallel). <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Pln& P1,const gp_Pln& P2,const Standard_Real TolAng,const Standard_Real Tol);
  //! Intersects two planes. <br>
//!          TolAng is the angular tolerance used to determine <br>
//!          if the planes are parallel. <br>
//!          Tol is the tolerance used to determine if the planes <br>
//!          are identical (only when they are parallel). <br>
  Standard_EXPORT     void Perform(const gp_Pln& P1,const gp_Pln& P2,const Standard_Real TolAng,const Standard_Real Tol) ;
  //! Creates the intersection between a plane and a cylinder. <br>
//!          TolAng is the angular tolerance used to determine <br>
//!          if the axis of the cylinder is parallel to the plane. <br>
//!          Tol is the tolerance used to determine if the result <br>
//!          is a circle or an ellipse. If the maximum distance between <br>
//!          the ellipse solution and the circle centered at the ellipse <br>
//!          center is less than Tol, the result will be the circle. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Pln& P,const gp_Cylinder& C,const Standard_Real Tolang,const Standard_Real Tol);
  //! Intersects a plane and a cylinder. <br>
//!          TolAng is the angular tolerance used to determine <br>
//!          if the axis of the cylinder is parallel to the plane. <br>
//!          Tol is the tolerance used to determine if the result <br>
//!          is a circle or an ellipse. If the maximum distance between <br>
//!          the ellipse solution and the circle centered at the ellipse <br>
//!          center is less than Tol, the result will be the circle. <br>
  Standard_EXPORT     void Perform(const gp_Pln& P,const gp_Cylinder& C,const Standard_Real Tolang,const Standard_Real Tol) ;
  //! Creates the intersection between a plane and a sphere. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Pln& P,const gp_Sphere& S);
  //! Intersects a plane and a sphere. <br>
  Standard_EXPORT     void Perform(const gp_Pln& P,const gp_Sphere& S) ;
  //! Creates the intersection between a plane and a cone. <br>
//!          TolAng is the angular tolerance used to determine <br>
//!          if the axis of the cone is parallel or perpendicular <br>
//!          to the plane, and if the generating line of the cone <br>
//!          is parallel to the plane. <br>
//!          Tol is the tolerance used to determine if the apex <br>
//!          of the cone is in the plane. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Pln& P,const gp_Cone& C,const Standard_Real Tolang,const Standard_Real Tol);
  //! Intersects a plane and a cone. <br>
//!          TolAng is the angular tolerance used to determine <br>
//!          if the axis of the cone is parallel or perpendicular <br>
//!          to the plane, and if the generating line of the cone <br>
//!          is parallel to the plane. <br>
//!          Tol is the tolerance used to determine if the apex <br>
//!          of the cone is in the plane. <br>
  Standard_EXPORT     void Perform(const gp_Pln& P,const gp_Cone& C,const Standard_Real Tolang,const Standard_Real Tol) ;
  //! Creates the intersection between two cylinders. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Cylinder& Cyl1,const gp_Cylinder& Cyl2,const Standard_Real Tol);
  //! Intersects two cylinders <br>
  Standard_EXPORT     void Perform(const gp_Cylinder& Cyl1,const gp_Cylinder& Cyl2,const Standard_Real Tol) ;
  //! Creates the intersection between a Cylinder and a Sphere. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Cylinder& Cyl,const gp_Sphere& Sph,const Standard_Real Tol);
  //! Intersects a cylinder and a sphere. <br>
  Standard_EXPORT     void Perform(const gp_Cylinder& Cyl,const gp_Sphere& Sph,const Standard_Real Tol) ;
  //! Creates the intersection between a Cylinder and a Cone <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Cylinder& Cyl,const gp_Cone& Con,const Standard_Real Tol);
  //! Intersects a cylinder and a cone. <br>
  Standard_EXPORT     void Perform(const gp_Cylinder& Cyl,const gp_Cone& Con,const Standard_Real Tol) ;
  //! Creates the intersection between two Spheres. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Sphere& Sph1,const gp_Sphere& Sph2,const Standard_Real Tol);
  //! Intersects a two spheres. <br>
  Standard_EXPORT     void Perform(const gp_Sphere& Sph1,const gp_Sphere& Sph2,const Standard_Real Tol) ;
  //! Creates the intersection beween a Sphere and a Cone. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Sphere& Sph,const gp_Cone& Con,const Standard_Real Tol);
  //! Intersects a sphere and a cone. <br>
  Standard_EXPORT     void Perform(const gp_Sphere& Sph,const gp_Cone& Con,const Standard_Real Tol) ;
  //! Creates the intersection beween two cones. <br>
  Standard_EXPORT   IntAna_QuadQuadGeo(const gp_Cone& Con1,const gp_Cone& Con2,const Standard_Real Tol);
  //! Intersects two cones. <br>
  Standard_EXPORT     void Perform(const gp_Cone& Con1,const gp_Cone& Con2,const Standard_Real Tol) ;
  //! Returns Standard_True if the computation was successful. <br>
//! <br>
        Standard_Boolean IsDone() const;
  //! Returns the type of intersection. <br>
//! <br>
        IntAna_ResultType TypeInter() const;
  //! Returns the number of interesections. <br>
//!          The possible intersections are : <br>
//!           - 1 point <br>
//!           - 1 or 2 line(s) <br>
//!           - 1 Point and 1 Line <br>
//!           - 1 circle <br>
//!           - 1 ellipse <br>
//!           - 1 parabola <br>
//!           - 1 or 2 hyperbola(s). <br>
//! <br>
        Standard_Integer NbSolutions() const;
  //! Returns the point solution of range Num. <br>
  Standard_EXPORT     gp_Pnt Point(const Standard_Integer Num) const;
  //! Returns the line solution of range Num. <br>
  Standard_EXPORT     gp_Lin Line(const Standard_Integer Num) const;
  //! Returns the circle solution of range Num. <br>
  Standard_EXPORT     gp_Circ Circle(const Standard_Integer Num) const;
  //! Returns the ellipse solution of range Num. <br>
  Standard_EXPORT     gp_Elips Ellipse(const Standard_Integer Num) const;
  //! Returns the parabola solution of range Num. <br>
  Standard_EXPORT     gp_Parab Parabola(const Standard_Integer Num) const;
  //! Returns the hyperbola solution of range Num. <br>
  Standard_EXPORT     gp_Hypr Hyperbola(const Standard_Integer Num) const;
  
  Standard_EXPORT     Standard_Boolean HasCommonGen() const;
  
  Standard_EXPORT    const gp_Pnt& PChar() const;





protected:

  //! Initialize the values of inner tolerances. <br>
  Standard_EXPORT     void InitTolerances() ;


Standard_Boolean done;
Standard_Integer nbint;
IntAna_ResultType typeres;
gp_Pnt pt1;
gp_Pnt pt2;
gp_Dir dir1;
gp_Dir dir2;
Standard_Real param1;
Standard_Real param2;
Standard_Real param1bis;
Standard_Real param2bis;
Standard_Real myEPSILON_DISTANCE;
Standard_Real myEPSILON_ANGLE_CONE;
Standard_Real myEPSILON_MINI_CIRCLE_RADIUS;
Standard_Real myEPSILON_CYLINDER_DELTA_RADIUS;
Standard_Real myEPSILON_CYLINDER_DELTA_DISTANCE;
Standard_Real myEPSILON_AXES_PARA;
Standard_Boolean myCommonGen;
gp_Pnt myPChar;


private:





};


#include <IntAna_QuadQuadGeo.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
