// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESToBRep_CurveAndSurface_HeaderFile
#define _IGESToBRep_CurveAndSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_IGESData_IGESModel_HeaderFile
#include <Handle_IGESData_IGESModel.hxx>
#endif
#ifndef _Handle_Transfer_TransientProcess_HeaderFile
#include <Handle_Transfer_TransientProcess.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
class Geom_Surface;
class IGESData_IGESModel;
class Transfer_TransientProcess;
class TopoDS_Shape;
class IGESData_IGESEntity;
class Message_Msg;


//! Provides methods to transfer CurveAndSurface from IGES to CASCADE. <br>
class IGESToBRep_CurveAndSurface  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates  a tool CurveAndSurface  ready  to  run, with <br>
//!         epsilons  set  to  1.E-04,  myModeTopo  to  True,  the <br>
//!         optimization of  the continuity to False. <br>
  Standard_EXPORT   IGESToBRep_CurveAndSurface();
  //! Creates a tool CurveAndSurface ready to run and sets its <br>
//!         fields as CS's. <br>
  Standard_EXPORT   IGESToBRep_CurveAndSurface(const IGESToBRep_CurveAndSurface& CS);
  //! Creates a tool CurveAndSurface ready to run. <br>
  Standard_EXPORT   IGESToBRep_CurveAndSurface(const Standard_Real eps,const Standard_Real epsGeom,const Standard_Real epsCoeff,const Standard_Boolean mode,const Standard_Boolean modeapprox,const Standard_Boolean optimized);
  //! Initializes the field of the tool CurveAndSurface with <br>
//!        default creating values. <br>
  Standard_EXPORT     void Init() ;
  //! Changes the value of "myEps" <br>
        void SetEpsilon(const Standard_Real eps) ;
  //! Returns the value of "myEps" <br>
        Standard_Real GetEpsilon() const;
  //! Changes the value of "myEpsCoeff" <br>
        void SetEpsCoeff(const Standard_Real eps) ;
  //! Returns the value of "myEpsCoeff" <br>
        Standard_Real GetEpsCoeff() const;
  //! Changes the value of "myEpsGeom" <br>
  Standard_EXPORT     void SetEpsGeom(const Standard_Real eps) ;
  //! Returns the value of "myEpsGeom" <br>
        Standard_Real GetEpsGeom() const;
  //! Changes the value of "myMinTol" <br>
        void SetMinTol(const Standard_Real mintol) ;
  //! Changes the value of "myMaxTol" <br>
        void SetMaxTol(const Standard_Real maxtol) ;
  //! Sets values of "myMinTol" and "myMaxTol" as follows <br>
//!           myMaxTol = Max ("read.maxprecision.val", myEpsGeom * myUnitFactor) <br>
//!           myMinTol = Precision::Confusion() <br>
//!  Remark:   This method is automatically invoked each time the values <br>
//!           of "myEpsGeom" or "myUnitFactor" are changed <br>
  Standard_EXPORT     void UpdateMinMaxTol() ;
  //! Returns the value of "myMinTol" <br>
        Standard_Real GetMinTol() const;
  //! Returns the value of "myMaxTol" <br>
        Standard_Real GetMaxTol() const;
  //! Changes the value of "myModeApprox" <br>
        void SetModeApprox(const Standard_Boolean mode) ;
  //! Returns the value of "myModeApprox" <br>
        Standard_Boolean GetModeApprox() const;
  //! Changes the value of "myModeIsTopo" <br>
        void SetModeTransfer(const Standard_Boolean mode) ;
  //! Returns the value of "myModeIsTopo" <br>
        Standard_Boolean GetModeTransfer() const;
  //! Changes the value of "myContIsOpti" <br>
        void SetOptimized(const Standard_Boolean optimized) ;
  //! Returns the value of "myContIsOpti" <br>
        Standard_Boolean GetOptimized() const;
  //! Returns the value of " myUnitFactor" <br>
        Standard_Real GetUnitFactor() const;
  //! Changes the value of "mySurfaceCurve" <br>
        void SetSurfaceCurve(const Standard_Integer ival) ;
  //! Returns the value of  " mySurfaceCurve" 0 = value in <br>
//!          file , 2  = kepp 2d   and compute 3d   3 = keep 3d and <br>
//!         compute 2d <br>
        Standard_Integer GetSurfaceCurve() const;
  //! Set the value of "myModel" <br>
  Standard_EXPORT     void SetModel(const Handle(IGESData_IGESModel)& model) ;
  //! Returns the value of "myModel" <br>
        Handle_IGESData_IGESModel GetModel() const;
  //! Changes the value of "myContinuity" <br>
//!           if continuity = 0 do nothing else <br>
//!           if continuity = 1 try C1 <br>
//!           if continuity = 2 try C2 <br>
        void SetContinuity(const Standard_Integer continuity) ;
  //! Returns the value of "myContinuity" <br>
        Standard_Integer GetContinuity() const;
  //! Set the value of "myMsgReg" <br>
        void SetTransferProcess(const Handle(Transfer_TransientProcess)& TP) ;
  //! Returns the value of "myMsgReg" <br>
        Handle_Transfer_TransientProcess GetTransferProcess() const;
  //! Returns the result of the transfert of any IGES Curve <br>
//!         or Surface Entity.  If  the transfer has  failed,  this <br>
//!         member return a NullEntity. <br>
  Standard_EXPORT     TopoDS_Shape TransferCurveAndSurface(const Handle(IGESData_IGESEntity)& start) ;
  //! Returns the result of the transfert the geometry of <br>
//!           any IGESEntity.  If  the transfer has  failed,  this <br>
//!           member return a NullEntity. <br>
  Standard_EXPORT     TopoDS_Shape TransferGeometry(const Handle(IGESData_IGESEntity)& start) ;
  //! Records a new Fail message <br>
        void SendFail(const Handle(IGESData_IGESEntity)& start,const Message_Msg& amsg) ;
  //! Records a new Warning message <br>
        void SendWarning(const Handle(IGESData_IGESEntity)& start,const Message_Msg& amsg) ;
  //! Records a new Information message from the definition <br>
//!           of a Msg (Original+Value) <br>
        void SendMsg(const Handle(IGESData_IGESEntity)& start,const Message_Msg& amsg) ;
  //! Returns True if start was already treated and has a result in "myMap" <br>
//!           else returns False. <br>
  Standard_EXPORT     Standard_Boolean HasShapeResult(const Handle(IGESData_IGESEntity)& start) const;
  //! Returns the result of the transfer of the IGESEntity "start" contained <br>
//!           in "myMap" . (if HasShapeResult is True). <br>
  Standard_EXPORT     TopoDS_Shape GetShapeResult(const Handle(IGESData_IGESEntity)& start) const;
  //! set in "myMap" the result of the transfer of the IGESEntity "start". <br>
  Standard_EXPORT     void SetShapeResult(const Handle(IGESData_IGESEntity)& start,const TopoDS_Shape& result) ;
  //! Returns the number of shapes results contained in "myMap" for the <br>
//!           IGESEntity start ( type VertexList or EdgeList). <br>
  Standard_EXPORT     Standard_Integer NbShapeResult(const Handle(IGESData_IGESEntity)& start) const;
  //! Returns the numth result of the IGESEntity start (type VertexList or <br>
//!           EdgeList) in "myMap". (if NbShapeResult is not null). <br>
  Standard_EXPORT     TopoDS_Shape GetShapeResult(const Handle(IGESData_IGESEntity)& start,const Standard_Integer num) const;
  //! set in "myMap" the result of the transfer of the entity of the <br>
//!           IGESEntity start ( type VertexList or EdgeList). <br>
  Standard_EXPORT     void AddShapeResult(const Handle(IGESData_IGESEntity)& start,const TopoDS_Shape& result) ;
  
  Standard_EXPORT     void SetSurface(const Handle(Geom_Surface)& theSurface) ;
  
  Standard_EXPORT     Handle_Geom_Surface Surface() const;
  
  Standard_EXPORT     Standard_Real GetUVResolution() ;





protected:





private:



Standard_Real myEps;
Standard_Real myEpsCoeff;
Standard_Real myEpsGeom;
Standard_Real myMinTol;
Standard_Real myMaxTol;
Standard_Boolean myModeIsTopo;
Standard_Boolean myModeApprox;
Standard_Boolean myContIsOpti;
Standard_Real myUnitFactor;
Standard_Integer mySurfaceCurve;
Standard_Integer myContinuity;
Handle_Geom_Surface mySurface;
Standard_Real myUVResolution;
Standard_Boolean myIsResolCom;
Handle_IGESData_IGESModel myModel;
Handle_Transfer_TransientProcess myTP;


};


#include <IGESToBRep_CurveAndSurface.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
