// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESData_DirChecker_HeaderFile
#define _IGESData_DirChecker_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IGESData_DefType_HeaderFile
#include <IGESData_DefType.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
class Interface_Check;
class IGESData_IGESEntity;


//! This class centralizes general Checks upon an IGES Entity's <br>
//!           Directory Part. That is : such field Ignored or Required, <br>
//!           or Required with a given Value (for an Integer field) <br>
//!           More precise checks can be performed as necessary, by each <br>
//!           Entity (method OwnCheck). <br>
//! <br>
//!           Each class of Entity defines its DirChecker (method DirChecker) <br>
//!           and the DirChecker is able to perform its Checks on an Entity <br>
//! <br>
//!           A Required Value or presence of a field causes a Fail Message <br>
//!           if criterium is not satisfied <br>
//!           An Ignored field causes a Correction Message if the field is <br>
//!           not null/zero <br>
class IGESData_DirChecker  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Returns a DirChecker, with no criterium at all to be checked <br>
  Standard_EXPORT   IGESData_DirChecker();
  //! Returns a DirChecker, with no criterium except Required Type <br>
  Standard_EXPORT   IGESData_DirChecker(const Standard_Integer atype);
  //! Returns a DirChecker, with no criterium except Required values <br>
//!           for Type and Form numbers <br>
  Standard_EXPORT   IGESData_DirChecker(const Standard_Integer atype,const Standard_Integer aform);
  //! Returns a DirChecker, with no criterium except Required values <br>
//!           for Type number (atype), and Required Range for Form number <br>
//!           (which must be between aform1 and aform2 included) <br>
  Standard_EXPORT   IGESData_DirChecker(const Standard_Integer atype,const Standard_Integer aform1,const Standard_Integer aform2);
  //! Returns True if at least one criterium has already been set <br>
//!           Allows user to store a DirChecker (static variable) then ask <br>
//!           if it has been set before setting it <br>
  Standard_EXPORT     Standard_Boolean IsSet() const;
  //! Sets a DirChecker with most current criteria, that is : <br>
//!           Structure Ignored ( worths call Structure(crit = DefVoid) ) <br>
  Standard_EXPORT     void SetDefault() ;
  //! Sets Structure criterium. <br>
//!           If crit is DefVoid, Ignored : should not be defined <br>
//!           If crit is DefReference, Required : must be defined <br>
//!           Other values are not taken in account <br>
  Standard_EXPORT     void Structure(const IGESData_DefType crit) ;
  //! Sets LineFont criterium <br>
//!           If crit is DefVoid, Ignored : should not be defined <br>
//!           If crit is DefAny, Required : must be defined (value or ref) <br>
//!           If crit is DefValue, Required as a Value (error if Reference) <br>
//!           Other values are not taken in account <br>
  Standard_EXPORT     void LineFont(const IGESData_DefType crit) ;
  //! Sets LineWeight criterium <br>
//!           If crit is DefVoid, Ignored : should not be defined <br>
//!           If crit is DefValue, Required <br>
//!           Other values are not taken in account <br>
  Standard_EXPORT     void LineWeight(const IGESData_DefType crit) ;
  //! Sets Color criterium <br>
//!           If crit is DefVoid, Ignored : should not be defined <br>
//!           If crit is DefAny, Required : must be defined (value or ref) <br>
//!           Other values are not taken in account <br>
  Standard_EXPORT     void Color(const IGESData_DefType crit) ;
  //! Sets Graphics data (LineFont, LineWeight, Color, Level, View) <br>
//!           to be ignored according value of Hierarchy status : <br>
//!           If hierarchy is not given, they are Ignored any way <br>
//!             (that is, they should not be defined) <br>
//!           If hierarchy is given, Graphics are Ignored if the Hierarchy <br>
//!           status has the value given in argument "hierarchy" <br>
  Standard_EXPORT     void GraphicsIgnored(const Standard_Integer hierarchy = -1) ;
  //! Sets Blank Status to be ignored <br>
//!            (should not be defined, or its value should be 0) <br>
  Standard_EXPORT     void BlankStatusIgnored() ;
  //! Sets Blank Status to be required at a given value <br>
  Standard_EXPORT     void BlankStatusRequired(const Standard_Integer val) ;
  //! Sets Subordinate Status to be ignored <br>
//!            (should not be defined, or its value should be 0) <br>
  Standard_EXPORT     void SubordinateStatusIgnored() ;
  //! Sets Subordinate Status to be required at a given value <br>
  Standard_EXPORT     void SubordinateStatusRequired(const Standard_Integer val) ;
  //! Sets Blank Status to be ignored <br>
//!            (should not be defined, or its value should be 0) <br>
  Standard_EXPORT     void UseFlagIgnored() ;
  //! Sets Blank Status to be required at a given value <br>
//!           Give -1 to demand UseFlag not zero (but no precise value req.) <br>
  Standard_EXPORT     void UseFlagRequired(const Standard_Integer val) ;
  //! Sets Hierarchy Status to be ignored <br>
//!            (should not be defined, or its value should be 0) <br>
  Standard_EXPORT     void HierarchyStatusIgnored() ;
  //! Sets Hierarchy Status to be required at a given value <br>
  Standard_EXPORT     void HierarchyStatusRequired(const Standard_Integer val) ;
  //! Performs the Checks on an IGESEntity, according to the <br>
//!           recorded criteria <br>
//!           In addition, does minimal Checks, such as admitted range for <br>
//!           Status, or presence of Error status in some data (Color, ...) <br>
  Standard_EXPORT     void Check(Handle(Interface_Check)& ach,const Handle(IGESData_IGESEntity)& ent) const;
  //! Performs a Check only on Values of Type Number and Form Number <br>
//!           This allows to do a check on an Entity not yet completely <br>
//!           filled but of which Type and Form Number have been already set <br>
  Standard_EXPORT     void CheckTypeAndForm(Handle(Interface_Check)& ach,const Handle(IGESData_IGESEntity)& ent) const;
  //! Corrects the Directory Entry of an IGES Entity as far as it is <br>
//!           possible according recorded criteria without any ambiguity : <br>
//!           - if a numeric Status is required a given value, this value is <br>
//!             enforced <br>
//!           - if an item is required to be Void, or if it recorded as <br>
//!             Erroneous, it is cleared (set to Void) <br>
//!           - Type Number is enforced <br>
//!           - finally Form Number is enforced only if one and only Value <br>
//!             is admitted (no range, see Constructors of DirChecker) <br>
  Standard_EXPORT     Standard_Boolean Correct(const Handle(IGESData_IGESEntity)& ent) const;





protected:





private:



Standard_Boolean isitset;
Standard_Integer thetype;
Standard_Integer theform1;
Standard_Integer theform2;
IGESData_DefType thestructure;
IGESData_DefType thelinefont;
IGESData_DefType thelineweig;
IGESData_DefType thecolor;
Standard_Integer thegraphier;
Standard_Integer theblankst;
Standard_Integer thesubordst;
Standard_Integer theuseflag;
Standard_Integer thehierst;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
