// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Convert_SphereToBSplineSurface_HeaderFile
#define _Convert_SphereToBSplineSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Convert_ElementarySurfaceToBSplineSurface_HeaderFile
#include <Convert_ElementarySurfaceToBSplineSurface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_DomainError;
class gp_Sphere;



//!  This algorithm converts a bounded Sphere into a rational <br>
//!  B-spline surface. The sphere is a Sphere from package gp. <br>
//!  The parametrization of the sphere is <br>
//!  P (U, V) = Loc  + Radius * Sin(V) * Zdir + <br>
//!             Radius * Cos(V) * (Cos(U)*Xdir + Sin(U)*Ydir) <br>
//!  where Loc is the center of the sphere Xdir, Ydir and Zdir are the <br>
//!  normalized directions of the local cartesian coordinate system of <br>
//!  the sphere. The parametrization range is U [0, 2PI] and <br>
//!  V [-PI/2, PI/2]. <br>
//! KeyWords : <br>
//!  Convert, Sphere, BSplineSurface. <br>
class Convert_SphereToBSplineSurface  : public Convert_ElementarySurfaceToBSplineSurface {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//!  The equivalent B-spline surface as the same orientation as the <br>
//!  sphere in the U and V parametric directions. <br>
//!  Raised if U1 = U2 or U1 = U2 + 2.0 * Pi <br>
//!  Raised if V1 = V2. <br>
  Standard_EXPORT   Convert_SphereToBSplineSurface(const gp_Sphere& Sph,const Standard_Real U1,const Standard_Real U2,const Standard_Real V1,const Standard_Real V2);
  
//!  The equivalent B-spline surface as the same orientation <br>
//!  as the sphere in the U and V parametric directions. <br>
//!  Raised if UTrim = True and Param1 = Param2 or <br>
//!            Param1 = Param2 + 2.0 * Pi <br>
//!  Raised if UTrim = False and Param1 = Param2 <br>
  Standard_EXPORT   Convert_SphereToBSplineSurface(const gp_Sphere& Sph,const Standard_Real Param1,const Standard_Real Param2,const Standard_Boolean UTrim = Standard_True);
  
//!  The equivalent B-spline surface as the same orientation <br>
//!  as the sphere in the U and V parametric directions. <br>
  Standard_EXPORT   Convert_SphereToBSplineSurface(const gp_Sphere& Sph);





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
