# RxJS Complete Module #

The Reactive Extensions for JavaScript's complete functionality is in the complete RxJS file which has many core components including the Schedulers, Disposables, Observable and Observer, but omits any testing capabilities.

This comes with both [`rx.all.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.all.js) which is for use in modern development environments such as > IE9 and server-side environments such as Node.js.  We also have [`rx.all.compat.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.all.compat.js) which has backwards compatibility to browsers which do not support all required ES5 features.

## Details ##

Files:
- [`rx.all.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.all.js)
- [`rx.all.compat.js`](https://github.com/Reactive-Extensions/RxJS/blob/master/dist/rx.all.compat.js)

NPM Packages:
- [`rx`](https://www.npmjs.org/package/rx)

NuGet Packages:
- [`RxJS-All`](http://www.nuget.org/packages/RxJS-All/)

## Included Observable Operators ##

### `Observable Methods`
- [`amb`](../../api/core/operators/amb.md)
- [`case`](../../api/core/operators/case.md)
- [`catch`](../../api/core/operators/catch.md)
- [`concat`](../../api/core/operators/concat.md)
- [`create`](../../api/core/operators/create.md)
- [`defer`](../../api/core/operators/defer.md)
- [`empty`](../../api/core/operators/empty.md)
- [`for`](../../api/core/operators/for.md)
- [`forkJoin`](../../api/core/operators/forkjoin.md)
- [`from`](../../api/core/operators/from.md)
- [`fromArray`](../../api/core/operators/fromarray.md)
- [`fromCallback`](../../api/core/operators/fromcallback.md)
- [`fromEvent`](../../api/core/operators/fromevent.md)
- [`fromEventPattern`](../../api/core/operators/fromeventpattern.md)
- [`fromNodeCallback`](../../api/core/operators/fromnodecallback.md)
- [`fromPromise`](../../api/core/operators/frompromise.md)
- [`generate`](../../api/core/operators/generate.md)
- [`generateWithAbsoluteTime`](../../api/core/operators/generatewithabsolutetime.md)
- [`generateWithRelativeTime`](../../api/core/operators/generatewithrelativetime.md)
- [`if`](../../api/core/operators/if.md)
- [`interval`](../../api/core/operators/interval.md)
- [`just`](../../api/core/operators/return.md)
- [`merge`](../../api/core/operators/merge.md)
- [`mergeDelayError`](../../api/core/operators/mergedelayerror.md)
- [`never`](../../api/core/operators/never.md)
- [`of`](../../api/core/operators/of.md)
- [`ofArrayChanges`](../../api/core/operators/ofarraychanges.md)
- [`ofObjectChanges`](../../api/core/operators/ofobjectchanges.md)
- [`ofWithScheduler`](../../api/core/operators/ofwithscheduler.md)
- [`onErrorResumeNext`](../../api/core/operators/onerrorresumenext.md)
- [`pairs`](../../api/core/operators/pairs.md)
- [`range`](../../api/core/operators/range.md)
- [`repeat`](../../api/core/operators/repeat.md)
- [`return`](../../api/core/operators/return.md)
- [`spawn`](../../api/core/operators/spawn.md)
- [`start`](../../api/core/operators/start.md)
- [`startAsync`](../../api/core/operators/startasync.md)
- [`throw`](../../api/core/operators/throw.md)
- [`timer`](../../api/core/operators/timer.md)
- [`toAsync`](../../api/core/operators/toasync.md)
- [`using`](../../api/core/operators/using.md)
- [`when`](../../api/core/operators/when.md)
- [`while`](../../api/core/operators/while.md)
- [`wrap`](../../api/core/operators/wrap.md)
- [`zip`](../../api/core/operators/zip.md)

### `Observable Instance Methods`
- [`aggregate`](../../api/core/operators/reduce.md)
- [`all`](../../api/core/operators/every.md)
- [`amb`](../../api/core/operators/ambproto.md)
- [`and`](../../api/core/operators/and.md)
- [`any`](../../api/core/operators/some.md)
- [`asObservable`](../../api/core/operators/asobservable.md)
- [`average`](../../api/core/operators/average.md)
- [`buffer`](../../api/core/operators/buffer.md)
- [`bufferWithCount`](../../api/core/operators/bufferwithcount.md)
- [`bufferWithTime`](../../api/core/operators/bufferwithtime.md)
- [`bufferWithTimeOrCount`](../../api/core/operators/bufferwithtimeorcount.md)
- [`catch`](../../api/core/operators/catchproto.md)
- [`combineLatest`](../../api/core/operators/combinelatest.md)
- [`concat`](../../api/core/operators/concatproto.md)
- [`concatAll`](../../api/core/operators/concatall.md)
- [`concatMap`](../../api/core/operators/concatmap.md)
- [`connect`](../../api/core/operators/connect.md)
- [`controlled`](../../api/core/operators/controlled.md)
- [`count`](../../api/core/operators/count.md)
- [`debounce`](../../api/core/operators/debounce.md)
- [`defaultIfEmpty`](../../api/core/operators/defaultifempty.md)
- [`delay`](../../api/core/operators/delay.md)
- [`delaySubscription`](../../api/core/operators/delaysubscription.md)
- [`dematerialize`](../../api/core/operators/dematerialize.md)
- [`distinct`](../../api/core/operators/distinct.md)
- [`distinctUntilChanged`](../../api/core/operators/distinctuntilchanged.md)
- [`do`](../../api/core/operators/do.md)
- [`doOnNext`](../../api/core/operators/doonnext.md)
- [`doOnError`](../../api/core/operators/doonerror.md)
- [`doOnCompleted`](../../api/core/operators/dooncompleted.md)
- [`doWhile`](../../api/core/operators/dowhile.md)
- [`elementAt`](../../api/core/operators/elementat.md)
- [`every`](../../api/core/operators/every.md)
- [`expand`](../../api/core/operators/expand.md)
- [`extend`](../../api/core/operators/manyselect.md)
- [`filter`](../../api/core/operators/where.md)
- [`finally | ensure`](../../api/core/operators/finally.md)
- [`find`](../../api/core/operators/find.md)
- [`findIndex`](../../api/core/operators/findindex.md)
- [`first`](../../api/core/operators/first.md)
- [`flatMap`](../../api/core/operators/selectmany.md)
- [`flatMapFirst`](../../api/core/operators/flatmapfirst.md)
- [`flatMapLatest`](../../api/core/operators/flatmaplatest.md)
- [`flatMapObserver`](../../api/core/operators/flatmapobserver.md)
- [`flatMapWithMaxConcurrent`](../../api/core/flatmapwithmaxconcurrent.md)
- [`forkJoin`](../../api/core/operators/forkjoinproto.md)
- [`groupBy`](../../api/core/operators/groupby.md)
- [`groupByUntil`](../../api/core/operators/groupbyuntil.md)
- [`groupJoin`](../../api/core/operators/groupjoin.md)
- [`ignoreElements`](../../api/core/operators/ignoreelements.md)
- [`includes`](../../api/core/operators/includes.md)
- [`isEmpty`](../../api/core/operators/isempty.md)
- [`join`](../../api/core/operators/join.md)
- [`last`](../../api/core/operators/last.md)
- [`lastIndexOf`](../../api/core/operators/lastindexof.md)
- [`let`](../../api/core/operators/let.md)
- [`manySelect`](../../api/core/operators/manyselect.md)
- [`map`](../../api/core/operators/select.md)
- [`max`](../../api/core/operators/max.md)
- [`maxBy`](../../api/core/operators/maxby.md)
- [`merge`](../../api/core/operators/mergeproto.md)
- [`mergeAll`](../../api/core/operators/mergeall.md)
- [`min`](../../api/core/operators/min.md)
- [`minBy`](../../api/core/operators/minby.md)
- [`multicast`](../../api/core/operators/multicast.md)
- [`observeOn`](../../api/core/operators/observeon.md)
- [`onErrorResumeNext`](../../api/core/operators/onerrorresumenextproto.md)
- [`pairwise`](../../api/core/operators/pairwise.md)
- [`partition`](../../api/core/operators/partition.md)
- [`pausable`](../../api/core/operators/pausable.md)
- [`pausableBuffered`](../../api/core/operators/pausablebuffered.md)
- [`pluck`](../../api/core/operators/pluck.md)
- [`publish`](../../api/core/operators/publish.md)
- [`publishLast`](../../api/core/operators/publishlast.md)
- [`publishValue`](../../api/core/operators/publishvalue.md)
- [`share`](../../api/core/operators/share.md)
- [`shareReplay`](../../api/core/operators/sharereplay.md)
- [`shareValue`](../../api/core/operators/sharevalue.md)
- [`refCount`](../../api/core/operators/refcount.md)
- [`reduce`](../../api/core/operators/reduce.md)
- [`repeat`](../../api/core/operators/repeat.md)
- [`replay`](../../api/core/operators/replay.md)
- [`retry`](../../api/core/operators/retry.md)
- [`retryWhen`](../../api/core/operators/retrywhen.md)
- [`sample`](../../api/core/operators/sample.md)
- [`scan`](../../api/core/operators/scan.md)
- [`select`](../../api/core/operators/select.md)
- [`selectConcat`](../../api/core/operators/selectconcat.md)
- [`selectMany`](../../api/core/operators/selectmany.md)
- [`selectManyObserver`](../../api/core/operators/selectmanyobserver.md)
- [`sequenceEqual`](../../api/core/operators/sequenceequal.md)
- [`single`](../../api/core/operators/single.md)
- [`singleInstance`](../../api/core/operators/singleinstance.md)
- [`skip`](../../api/core/operators/skip.md)
- [`skipLast`](../../api/core/operators/skiplast.md)
- [`skipLastWithTime`](../../api/core/operators/skiplastwithtime.md)
- [`skipUntil`](../../api/core/operators/skipuntil.md)
- [`skipUntilWithTime`](../../api/core/operators/skipuntilwithtime.md)
- [`skipWhile`](../../api/core/operators/skipwhile.md)
- [`slice`](../../api/core/operators/slice.md)
- [`some`](../../api/core/operators/some.md)
- [`startWith`](../../api/core/operators/startwith.md)
- [`subscribe | forEach`](../../api/core/operators/subscribe.md)
- [`subscribeOn`](../../api/core/operators/subscribeon.md)
- [`sum`](../../api/core/operators/sum.md)
- [`switch | switchLatest`](../../api/core/operators/switch.md)
- [`switchFirst`](../../api/core/operators/switchfirst.md)
- [`take`](../../api/core/operators/take.md)
- [`takeLast`](../../api/core/operators/takelast.md)
- [`takeLastBuffer`](../../api/core/operators/takelastbuffer.md)
- [`takeLastBufferWithTime`](../../api/core/operators/takelastbufferwithtime.md)
- [`takeLastWithTime`](../../api/core/operators/takelastwithtime.md)
- [`takeUntil`](../../api/core/operators/takeuntil.md)
- [`takeUntilWithTime`](../../api/core/operators/takeuntilwithtimee.md)
- [`takeWhile`](../../api/core/operators/takewhile.md)
- [`tap`](../../api/core/operators/do.md)
- [`tapOnNext`](../../api/core/operators/doonnext.md)
- [`tapOnError`](../../api/core/operators/doonerror.md)
- [`tapOnCompleted`](../../api/core/operators/dooncompleted.md)
- [`throttle`](../../api/core/operators/throttle.md)
- [`timeInterval`](../../api/core/operators/timeinterval.md)
- [`timeout`](../../api/core/operators/timeout.md)
- [`timestamp`](../../api/core/operators/timestamp.md)
- [`toArray`](../../api/core/operators/toarray.md)
- [`where`](../../api/core/operators/where.md)
- [`window`](../../api/core/operators/window.md)
- [`windowWithCount`](../../api/core/operators/windowwithcount.md)
- [`windowWithTime`](../../api/core/operators/windowwithtime.md)
- [`windowWithTimeOrCount`](../../api/core/operators/windowwithtimeorcount.md)
- [`withLatestFrom`](../../api/core/operators/withlatestfrom.md)
- [`zip`](../../api/core/operators/zipproto.md)
- [`zipIterable`](../../api/core/operators/zipiterable.md)

## Included Classes ##

### Core Objects

- [`Rx.Observer`](../../api/core/observer.md)
- [`Rx.Notification`](../../api/core/notification.md)

### Subjects

- [`Rx.AsyncSubject`](../../api/subjects/asyncsubject.md)
- [`Rx.Subject`](../../api/subjects/subject.md)

### Schedulers

- [`Rx.Scheduler`](../../api/schedulers/scheduler.md)

### Disposables

- [`Rx.CompositeDisposable`](../../api/disposables/compositedisposable.md)
- [`Rx.Disposable`](../../api/disposables/disposable.md)
- [`Rx.RefCountDisposable`](../../api/disposables/refcountdisposable.md)
- [`Rx.SerialDisposable`](../../api/disposables/serialdisposable.md)
- [`Rx.SingleAssignmentDisposable`](../../api/disposables/singleassignmentdisposable.md)
