/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberInstruction
extends Expression {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression ordinal = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns;
    private boolean backwardsCompatible;

    public NumberInstruction(Configuration config, Expression select, int level, Pattern count, Pattern from, Expression value, Expression format, Expression groupSize, Expression groupSeparator, Expression letterValue, Expression ordinal, Expression lang, NumberFormatter formatter, Numberer numberer, boolean hasVariablesInPatterns, boolean backwardsCompatible) {
        this.select = select;
        this.level = level;
        this.count = count;
        this.from = from;
        this.value = value;
        this.format = format;
        this.groupSize = groupSize;
        this.groupSeparator = groupSeparator;
        this.letterValue = letterValue;
        this.ordinal = ordinal;
        this.lang = lang;
        this.formatter = formatter;
        this.numberer = numberer;
        this.hasVariablesInPatterns = hasVariablesInPatterns;
        this.backwardsCompatible = backwardsCompatible;
        TypeHierarchy th = config.getTypeHierarchy();
        if (this.value != null && !this.value.getItemType(th).isAtomicType()) {
            this.value = new Atomizer(this.value);
        }
        Iterator<Expression> kids = this.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression child = kids.next();
            this.adoptChildExpression(child);
        }
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.value = visitor.simplify(this.value);
        this.format = visitor.simplify(this.format);
        this.groupSize = visitor.simplify(this.groupSize);
        this.groupSeparator = visitor.simplify(this.groupSeparator);
        this.letterValue = visitor.simplify(this.letterValue);
        this.ordinal = visitor.simplify(this.ordinal);
        this.lang = visitor.simplify(this.lang);
        if (this.count != null) {
            this.count = this.count.simplify(visitor);
        }
        if (this.from != null) {
            this.from = this.from.simplify(visitor);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.typeCheck(this.select, contextItemType);
        } else if (this.value == null) {
            XPathException err = null;
            if (contextItemType == null) {
                err = new XPathException("xsl:number requires a select attribute, a value attribute, or a context item");
            } else if (contextItemType.isAtomicType()) {
                err = new XPathException("xsl:number requires the context item to be a node, but it is an atomic value");
            }
            if (err != null) {
                err.setIsTypeError(true);
                err.setErrorCode("XTTE0990");
                err.setLocator(this);
                throw err;
            }
        }
        if (this.value != null) {
            this.value = visitor.typeCheck(this.value, contextItemType);
        }
        if (this.format != null) {
            this.format = visitor.typeCheck(this.format, contextItemType);
        }
        if (this.groupSize != null) {
            this.groupSize = visitor.typeCheck(this.groupSize, contextItemType);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = visitor.typeCheck(this.groupSeparator, contextItemType);
        }
        if (this.letterValue != null) {
            this.letterValue = visitor.typeCheck(this.letterValue, contextItemType);
        }
        if (this.ordinal != null) {
            this.ordinal = visitor.typeCheck(this.ordinal, contextItemType);
        }
        if (this.lang != null) {
            this.lang = visitor.typeCheck(this.lang, contextItemType);
        }
        if (this.count != null) {
            this.count = this.count.analyze(visitor, contextItemType);
        }
        if (this.from != null) {
            this.from = this.from.analyze(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
        }
        if (this.value != null) {
            this.value = visitor.optimize(this.value, contextItemType);
        }
        if (this.format != null) {
            this.format = visitor.optimize(this.format, contextItemType);
        }
        if (this.groupSize != null) {
            this.groupSize = visitor.optimize(this.groupSize, contextItemType);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = visitor.optimize(this.groupSeparator, contextItemType);
        }
        if (this.letterValue != null) {
            this.letterValue = visitor.optimize(this.letterValue, contextItemType);
        }
        if (this.ordinal != null) {
            this.ordinal = visitor.optimize(this.ordinal, contextItemType);
        }
        if (this.lang != null) {
            this.lang = visitor.optimize(this.lang, contextItemType);
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> sub = new ArrayList<Expression>(9);
        if (this.select != null) {
            sub.add(this.select);
        }
        if (this.value != null) {
            sub.add(this.value);
        }
        if (this.format != null) {
            sub.add(this.format);
        }
        if (this.groupSize != null) {
            sub.add(this.groupSize);
        }
        if (this.groupSeparator != null) {
            sub.add(this.groupSeparator);
        }
        if (this.letterValue != null) {
            sub.add(this.letterValue);
        }
        if (this.ordinal != null) {
            sub.add(this.ordinal);
        }
        if (this.lang != null) {
            sub.add(this.lang);
        }
        if (this.count != null) {
            sub.add(new PatternSponsor(this.count));
        }
        if (this.from != null) {
            sub.add(new PatternSponsor(this.from));
        }
        return sub.iterator();
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.value == original) {
            this.value = replacement;
            found = true;
        }
        if (this.format == original) {
            this.format = replacement;
            found = true;
        }
        if (this.groupSize == original) {
            this.groupSize = replacement;
            found = true;
        }
        if (this.groupSeparator == original) {
            this.groupSeparator = replacement;
            found = true;
        }
        if (this.letterValue == original) {
            this.letterValue = replacement;
            found = true;
        }
        if (this.ordinal == original) {
            this.ordinal = replacement;
            found = true;
        }
        if (this.lang == original) {
            this.lang = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.select == null ? 2 : 0;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (this.select != null) {
            this.select = this.doPromotion(this, this.select, offer);
        }
        if (this.value != null) {
            this.value = this.doPromotion(this, this.value, offer);
        }
        if (this.format != null) {
            this.format = this.doPromotion(this, this.format, offer);
        }
        if (this.groupSize != null) {
            this.groupSize = this.doPromotion(this, this.groupSize, offer);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = this.doPromotion(this, this.groupSeparator, offer);
        }
        if (this.letterValue != null) {
            this.letterValue = this.doPromotion(this, this.letterValue, offer);
        }
        if (this.ordinal != null) {
            this.ordinal = this.doPromotion(this, this.ordinal, offer);
        }
        if (this.lang != null) {
            this.lang = this.doPromotion(this, this.lang, offer);
        }
        if (this.count != null) {
            this.count.promote(offer, this);
        }
        if (this.from != null) {
            this.from.promote(offer, this);
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumberFormatter nf;
        String letterVal;
        long value = -1L;
        List<Long> vec = null;
        if (this.value != null) {
            AtomicValue val;
            SequenceIterator iter = this.value.iterate(context);
            vec = new ArrayList<String>(4);
            while ((val = (AtomicValue)iter.next()) != null && (!this.backwardsCompatible || vec.isEmpty())) {
                try {
                    NumericValue num = val instanceof NumericValue ? (NumericValue)val : NumberFn.convert(val);
                    if (num.isNaN()) {
                        throw new XPathException("NaN");
                    }
                    if ((num = num.round()).compareTo(Int64Value.MAX_LONG) > 0) {
                        vec.add((Long)((Object)((BigIntegerValue)num.convert(BuiltInAtomicType.INTEGER, true, context).asAtomic()).asBigInteger()));
                        continue;
                    }
                    if (num.compareTo(Int64Value.ZERO) < 0) {
                        throw new XPathException("The numbers to be formatted must not be negative");
                    }
                    long i = ((NumericValue)num.convert(BuiltInAtomicType.INTEGER, true, context).asAtomic()).longValue();
                    vec.add(new Long(i));
                }
                catch (XPathException err) {
                    if (this.backwardsCompatible) {
                        vec.add((Long)((Object)"NaN"));
                        continue;
                    }
                    vec.add((Long)((Object)val.getStringValue()));
                    XPathException e = new XPathException("Cannot convert supplied value to an integer. " + err.getMessage());
                    e.setErrorCode("XTDE0980");
                    e.setXPathContext(context);
                    throw e;
                }
            }
            if (this.backwardsCompatible && vec.isEmpty()) {
                vec.add((Long)((Object)"NaN"));
            }
        } else {
            NodeInfo source;
            if (this.select != null) {
                source = (NodeInfo)this.select.evaluateItem(context);
            } else {
                Item item = context.getContextItem();
                if (!(item instanceof NodeInfo)) {
                    XPathException err = new XPathException("context item for xsl:number must be a node");
                    err.setErrorCode("XTTE0990");
                    err.setIsTypeError(true);
                    err.setXPathContext(context);
                    throw err;
                }
                source = (NodeInfo)item;
            }
            if (this.level == 3) {
                value = Navigator.getNumberSimple(source, context);
            } else if (this.level == 0) {
                value = Navigator.getNumberSingle(source, this.count, this.from, context);
                if (value == 0L) {
                    vec = Collections.EMPTY_LIST;
                }
            } else if (this.level == 2) {
                value = Navigator.getNumberAny(this, source, this.count, this.from, context, this.hasVariablesInPatterns);
                if (value == 0L) {
                    vec = Collections.EMPTY_LIST;
                }
            } else if (this.level == 1) {
                vec = Navigator.getNumberMulti(source, this.count, this.from, context);
            }
        }
        int gpsize = 0;
        String gpseparator = "";
        String ordinalVal = null;
        if (this.groupSize != null) {
            String g = ((Object)this.groupSize.evaluateAsString(context)).toString();
            try {
                gpsize = Integer.parseInt(g);
            }
            catch (NumberFormatException err) {
                XPathException e = new XPathException("grouping-size must be numeric");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                throw e;
            }
        }
        if (this.groupSeparator != null) {
            gpseparator = ((Object)this.groupSeparator.evaluateAsString(context)).toString();
        }
        if (this.ordinal != null) {
            ordinalVal = ((Object)this.ordinal.evaluateAsString(context)).toString();
        }
        if (vec == null && this.format == null && gpsize == 0 && this.lang == null) {
            return new StringValue("" + value);
        }
        Numberer numb = this.numberer;
        if (numb == null) {
            String language = ((Object)this.lang.evaluateAsString(context)).toString();
            numb = context.getConfiguration().makeNumberer(language, null);
        }
        if (this.letterValue == null) {
            letterVal = "";
        } else {
            letterVal = ((Object)this.letterValue.evaluateAsString(context)).toString();
            if (!"alphabetic".equals(letterVal) && !"traditional".equals(letterVal)) {
                XPathException e = new XPathException("letter-value must be \"traditional\" or \"alphabetic\"");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                throw e;
            }
        }
        if (vec == null) {
            vec = new ArrayList(1);
            vec.add(new Long(value));
        }
        if (this.formatter == null) {
            nf = new NumberFormatter();
            nf.prepare(((Object)this.format.evaluateAsString(context)).toString());
        } else {
            nf = this.formatter;
        }
        CharSequence s = nf.format(vec, gpsize, gpseparator, letterVal, ordinalVal, numb);
        return new StringValue(s);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("xslNumber");
        out.emitAttribute("level", this.level == 2 ? "any" : (this.level == 0 ? "single" : "multi"));
        if (this.count != null) {
            out.emitAttribute("count", this.count.toString());
        }
        if (this.from != null) {
            out.emitAttribute("from", this.from.toString());
        }
        if (this.select != null) {
            out.startSubsidiaryElement("select");
            this.select.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.value != null) {
            out.startSubsidiaryElement("value");
            this.value.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.format != null) {
            out.startSubsidiaryElement("format");
            this.format.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

