/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.claribole.zvtm.glyphs.VImageST;

public class RImage
extends VImageST {
    static float REFLECTION_HEIGHT_RATIO = 0.5f;
    static float REFLECTION_MASK_ALPHA_BASE = 0.2f;
    static float REFLECTION_MASK_ALPHA_EDGE = 0.0f;
    boolean irihc = false;

    public static void setReflectionHeight(float ratio) {
        REFLECTION_HEIGHT_RATIO = ratio;
    }

    public static void setReflectionMaskEndPoints(float base, float edge) {
        REFLECTION_MASK_ALPHA_BASE = base;
        REFLECTION_MASK_ALPHA_EDGE = edge;
    }

    public RImage(Image img, float a) {
        super(img, a);
        this.image = RImage.createReflection(img);
    }

    public RImage(long x, long y, int z, Image img, float a) {
        super(x, y, z, img, a);
        this.image = RImage.createReflection(img);
    }

    public RImage(long x, long y, int z, Image img, double scale, float a) {
        super(x, y, z, img, scale, a);
        this.image = RImage.createReflection(img);
    }

    public RImage(long x, long y, int z, Image img, double scale, float a, boolean hir) {
        super(x, y, z, img, scale, a);
        this.image = RImage.createReflection(img);
        this.irihc = hir;
        if (this.irihc) {
            // empty if block
        }
    }

    public boolean includesReflectionInHeightComputation() {
        return this.irihc;
    }

    public void setImage(Image i) {
        this.image = RImage.createReflection(i);
        this.vw = Math.round((double)this.image.getWidth(null) / 2.0);
        this.vh = Math.round((double)this.image.getHeight(null) / 4.0);
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getHeight() {
        return this.irihc ? this.vh : this.vh / 2L;
    }

    public Object clone() {
        RImage res = new RImage(this.vx, this.vy, 0, this.image, this.alpha);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        res.setDrawBorderPolicy(this.drawBorder);
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }

    public static BufferedImage getBufferedImageFromFile(File f) {
        try {
            return ImageIO.read(f);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static BufferedImage createReflection(Image src) {
        return RImage.createReflection(src, new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, REFLECTION_MASK_ALPHA_BASE), 0.0f, Math.round((float)src.getHeight(null) * REFLECTION_HEIGHT_RATIO), new Color(1.0f, 1.0f, 1.0f, REFLECTION_MASK_ALPHA_EDGE)));
    }

    public static BufferedImage createReflection(Image src, GradientPaint mask) {
        int height = src.getHeight(null);
        BufferedImage target = new BufferedImage(src.getWidth(null), height * 2, 2);
        Graphics2D g2 = target.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.scale(1.0, -1.0);
        g2.drawImage(src, 0, -height - height, null);
        g2.scale(1.0, -1.0);
        g2.translate(0, height);
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, src.getWidth(null), height);
        g2.dispose();
        return target;
    }
}

