/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;

public class Utils {
    public static void tile(String src, String targetPattern, int tileSize) {
        try {
            File source = new File(src);
            ImageInputStream iis = ImageIO.createImageInputStream(source);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle sourceRegion = new Rectangle();
            int w = reader.getWidth(0);
            int h = reader.getHeight(0);
            int c = 1;
            for (int y = 0; y < h; y += tileSize) {
                int th = Math.min(tileSize, h - y);
                sourceRegion.y = y;
                sourceRegion.height = th;
                for (int x = 0; x < w; x += tileSize) {
                    System.out.println("tile " + c);
                    File target = new File(targetPattern + Integer.toString(c) + ".png");
                    int tw = Math.min(tileSize, w - x);
                    sourceRegion.x = x;
                    sourceRegion.width = tw;
                    param.setSourceRegion(sourceRegion);
                    BufferedImage bi = reader.read(0, param);
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
                    writer.setOutput(ImageIO.createImageOutputStream(target));
                    writer.write(bi);
                    writer.dispose();
                    ++c;
                    System.gc();
                }
            }
            reader.dispose();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Image readImage(String filePath) {
        try {
            File source = new File(filePath);
            ImageInputStream iis = ImageIO.createImageInputStream(source);
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("png");
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            BufferedImage bi = reader.read(0, param);
            reader.dispose();
            return bi;
        }
        catch (IOException ex) {
            System.err.println("Failed to load image " + filePath);
            return null;
        }
    }

    public static void main(String[] args) {
        Utils.tile(args[0], args[1], Integer.parseInt(args[2]));
    }
}

