/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: messages_fifo.h,v 1.32 2008-02-23 08:35:02 anton Exp $ */


//////////////////////////////////////////////////////////////////////////
// Message class
#define NUM_MSG_TYPES	6

typedef u_char  message_type;
#define MSG_STORE	0
#define MSG_READ	1
#define MSG_ALERT	2
#define MSG_COMMAND	3
#define MSG_ACLSERVER	5


class Message {
	private:
		pthread_mutex_t lock;
	public:
		u_char active;
		Message *next;
		message_type type;
		Message(message_type t);
		virtual ~Message();
		void Push();
		void Pop();
};

class Message_Read: public Message {
	public:
		oid netunit;
		oid ap;
		policy_data *pdata;
		Message_Read();
		~Message_Read();
};

class Message_Store: public Message {
	public:
		oid netunit;
		oid ap;
		pstat *data;
		char prefix; // M, W, D, H, F, O
		time_t ts;
		Message_Store();
		~Message_Store();
};

class Message_Alert: public Message {
	public:
		alert *al;
		Message_Alert();
		~Message_Alert();
};

class Message_AclServer: public Message {
	public:
		struct in_addr ip;
		u_char flag;
		Message_AclServer();
		~Message_AclServer();
};
//////////////////////////////////////////////////////////////////////////
typedef struct MsgHolder {
        Message *msg;
        MsgHolder *next;
        } MsgHolder;
//////////////////////////////////////////////////////////////////////////
// FIFO class
class FIFO {
	private:
		pthread_mutex_t lock;
	public:
		MsgHolder *root;
		MsgHolder *last;
		MsgHolder *ready;
		unsigned num_items;
		unsigned max_items;
		unsigned long total_items;
		unsigned num_holders;
		FIFO(unsigned max);
		~FIFO();
		MsgHolder *newHolder();
		void freeHolder(MsgHolder *h);
		u_char Push(Message *msg);
		Message *TryPop();
		Message *Pop();
};
//////////////////////////////////////////////////////////////////////////
class MessageManager {
	private:
		pthread_mutex_t lock;
	public:
		Message *ready[NUM_MSG_TYPES];
		unsigned ready_items[NUM_MSG_TYPES];
		unsigned allocated[NUM_MSG_TYPES];
		unsigned total_ready_items;
		unsigned total_allocated;	

		MessageManager();
		~MessageManager();
		Message* New(message_type t);
		void Delete(Message *msg);
		void Usage(struct cli_def *cli);
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
 
