/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: iptree.h,v 1.27 2008-02-23 08:35:02 anton Exp $ */

typedef struct IPTree_node {
	IPTree_node *up;
	IPTree_node **next;
	void *ptr;
} __attribute__((packed)) IPTree_node;

// this using un datasource service as unit list representation
typedef struct dsUlist {
	NetUnit **list;	//ELIST

	//this used to organize matched units in list
	//for 0-account, 1-forward check
	dsUlist *link[2];
	match mf[2];
} __attribute__((packed)) dsUlist;
/////////////////////////////////////////////////////////////////////////////////////
class IPTree {
	public:
		unsigned long nodes; //number of IPTree_node allocated
		unsigned long dlink; //number of *IPTree_node[256] allocated;
		unsigned long unodes; //number of dsUlist allocated
		IPTree_node *root;
		pthread_rwlock_t rwlock;
		u_char instance;

		IPTree(u_char instance);
		~IPTree();
		void FreeTree(IPTree_node *node); //this organize locks
		void freetree(IPTree_node *node); //this makes recursion and real free
		u_char cleanup(IPTree_node *node);
		void add2node(IPTree_node *node,NetUnit *u,u_char flag);
		void addr2tree(unsigned addr,u_char mask,NetUnit *u,u_char flag);
		dsUlist *checktree(Flow *flow, u_char check);
		void showtree(IPTree_node *node,unsigned addr,u_char depth);
		
		void ACCT(Flow *flow);
		void DSacct(NetUnit *u, Flow *flow, match mf);
};
/////////////////////////////////////////////////////////////////////////////////////
class PrefixTree {
        public:
		unsigned long nodes; //number of IPTree_node allocated
		unsigned long dlink; //number of *IPTree_node[256] allocated;
                IPTree_node *root;
		// we do not need lock here cause it's worked in PrefixFile class and locked here
                PrefixTree();
                ~PrefixTree();
                void freetree(IPTree_node *node); //this makes recursion and real free
                void prefix2tree(net_prefix *p);
                u_char checktree(unsigned addr);
};
/////////////////////////////////////////////////////////////////////////////////////

		
