/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: billing.h,v 1.81 2009-08-01 09:23:55 anton Exp $ */

struct Billing_cfg;
struct bUlist;
struct FeeCounters;

FeeCounters* PrepareFeeCounters();

class PlansList;
class SubPlansList;
class AccountsList;

class Plan;
class SubPlan;
class Account;

extern PlansList *bPlans;
extern SubPlansList *bSubPlans;
extern AccountsList *bAccounts;

//////////////////////////////////////////////////////////////////////////
extern struct FeeCounters FC;
//////////////////////////////////////////////////////////////////////////
class PlansList :public List {
	public:
		PlansList() {};
		~PlansList() {};
	};
//////////////////////////////////////////////////////////////////////////
class SubPlansList: public List {
	public:
		SubPlansList() {};
		~SubPlansList() {};
	};
//////////////////////////////////////////////////////////////////////////
// sure there is no interaction with POLICY_FLAG_*
#define SPLAN_NONE		0
#define SPLAN_UNLIM_IN		0x01   
#define SPLAN_UNLIM_OUT		0x02
#define SPLAN_UNLIM_SUM		(SPLAN_UNLIM_IN|SPLAN_UNLIM_OUT)
#define SPLAN_SUM		0x04

class SubPlan: public Object {
	public:
		SubPlan(oid newid);
		~SubPlan() {};
		float fee;
		char spread;
		unsigned long long inc_in;
		unsigned long long inc_out;
		unsigned inc_adjust; // we allow 'slow adjustment' of included traffic? default is NO=0
		unsigned fee_adjust; // we allow taking fees proportionally to the day of month? default is YES=1
		u_char flags;
		policy_flag policy_flags;
		oid pid;
		float pay_in, pay_out;
		double overdraft_in;
		double overdraft_out;
		u_short connected_plans;
	};
//////////////////////////////////////////////////////////////////////////

// subplan  representation
typedef struct bSPlist {
        SubPlan *sp;
        bSPlist *next;
        } bSPlist;

class Plan : public Object {
	public:
		Plan(oid newid);
		~Plan();
		char *name;
		char *description;
		bSPlist *root;
		u_char num_subplans;
		unsigned connected_accounts;
		u_char AddSubPlan(SubPlan *sp, u_char flag); //ADD|REMOVE
		void SetAccountData(Account *ac); //set preincluded traffic for account
	};
//////////////////////////////////////////////////////////////////////////
class AccountsList: public List {
	public:
		AccountsList();
		~AccountsList() {};
		Account *Get(char *param);
		time_t last_update;
		void RestoreAccounts();
		void UpdateAccounts();
		unsigned max_accounts_number_set;
		};
//////////////////////////////////////////////////////////////////////////
typedef struct bstat {
	double pay_in;
	double pay_out;
	long long in;
	long long out;
	time_t from;
	} bstat;

#define	BDATA_NEED_SYNC	0x01

typedef struct biling_data {
	long long flow_in, flow_out;
	bstat h,d,w,m;
	u_char flags;
} billing_data;

// this using unit representation
typedef struct bUlist {
	NetUnit *u;
	bUlist *next;
	} bUlist;

//this is for fee multipliers and time counters
typedef struct FeeCounters {
	time_t now;
	time_t ht;
	time_t dt;
	time_t wt;
	time_t mt;
	double hour_mult;
	double day_mult;
	double month_mult;
	double traf_mult;
} FeeCounters;

enum balance_action	{ BAL_ADD, BAL_REMOVE, BAL_SET };
enum status_action	{ AC_BLOCK, AC_BEBLOCK, AC_UNBLOCK, AC_DENY, AC_PASS };

#define ACCOUNT_NEED_SYNC	0x01
#define ACCOUNT_DENIED		0x02
#define ACCOUNT_BLOCKED		0x04
#define ACCOUNT_DELETED		0x08
#define ACCOUNT_BEBLOCKED	0x10
#define ACCOUNT_BDATA_NEED_SYNC	0x20

class Account: public Object {
	public:
		char *name;
		char *password;
		char *email;
		char *description;
		time_t blocked;
		time_t created;
		time_t changed;
		time_t last_fee_ch;
		time_t plan_ch;
		time_t nextplan_ch;
		u_char status;
		Plan *plan;
		Plan *nextplan;
		bUlist *bUroot;  //Units that belongs to account
		u_char num_units;
		billing_data *data;
		u_char AddUnit(NetUnit *u, u_char flag); //ADD|REMOVE
		void Update(Plan *pl);
		void SetUnitAccountPolicy(NetUnit *u, u_char flag); 
		void UpdateStatus(status_action action, time_t change_t); //BLOCK PASS 
		void AccountMessage(Message_Store *msg);
		void ChargeFee();
		void setName(char *name);
		void SyncAccount(FILE *f);
		unsigned SyncBdata(FILE *f);
		Account();
		~Account();
		void Balance(float amount, balance_action action);
		double balance;
		double credit_limit;
	};
//////////////////////////////////////////////////////////////////////////
