/* $Id: Trna_ext.cpp 499339 2016-04-25 18:08:43Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqfeat.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/seqfeat/Trna_ext.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CTrna_ext::~CTrna_ext(void)
{
}


static const char *codonLetterExpand[] =
{
    "?", "A", "C", "AC",
    "G", "AG", "CG", "ACG",
    "T", "AT", "CT", "ACT",
    "GT", "AGT", "CGT", "ACGT",
    NULL
};


bool CTrna_ext::ParseDegenerateCodon(CTrna_ext & tRNA, const string & codon)
{
    const static string intToChr = "?ACMGRSVTWYHKDBN";

    if (codon.length() < 3) {
        return false;
    }

    // the first two have to be real nucleotides
    const string::size_type first_bad_char = codon.find_first_not_of("ACGT");
    if (first_bad_char != string::npos && first_bad_char < 2) {
        return false;
    }

    int idx = intToChr.find(codon[2]);
    if (idx == (int)string::npos) return false;

    const char *expanded_codon_letter = codonLetterExpand[idx];
    const char *iter = expanded_codon_letter;
    char ch = *iter;
    int tRNA_codon_idx = 0;
    string codon_copy = codon;
    codon_copy.erase(3);
    tRNA.SetCodon().clear();
    while (*iter != '\0' && tRNA_codon_idx < 6) {
        codon_copy[2] = ch;
        tRNA.SetCodon().push_back(CGen_code_table::CodonToIndex(codon_copy)); // TODO: make sure Seq_code_iupacna

        // prepare for next iteration
        iter++;
        ch = *iter;
        tRNA_codon_idx++;
    }

    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1721, CRC32: d561a0b8 */
