/*  $Id: ecnum_ambiguous.inc 433107 2014-04-22 20:06:13Z kans $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  The Enzyme Commission
 *
 * File Description:
 *   Built-in copy of ecnum_ambiguous.txt.
 *
 */

static const char* const kECNum_ambiguous[] = {
    "1.-.-.-	Oxidoreductases",
    "1.n.n.n	Oxidoreductases",
    "1.1.-.-	Acting on the CH-OH group of donors",
    "1.1.n.n	Acting on the CH-OH group of donors",
    "1.1.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.1.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.1.2.-	With a cytochrome as acceptor",
    "1.1.2.n	With a cytochrome as acceptor",
    "1.1.3.-	With oxygen as acceptor",
    "1.1.3.n	With oxygen as acceptor",
    "1.1.4.-	With a disulfide as acceptor",
    "1.1.4.n	With a disulfide as acceptor",
    "1.1.5.-	With a quinone or similar compound as acceptor",
    "1.1.5.n	With a quinone or similar compound as acceptor",
    "1.1.9.-	With a copper protein as acceptor",
    "1.1.9.n	With a copper protein as acceptor",
    "1.1.98.-	With other, known, acceptors",
    "1.1.98.n	With other, known, acceptors",
    "1.1.99.-	With other acceptors",
    "1.1.99.n	With other acceptors",
    "1.2.-.-	Acting on the aldehyde or oxo group of donors",
    "1.2.n.n	Acting on the aldehyde or oxo group of donors",
    "1.2.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.2.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.2.2.-	With a cytochrome as acceptor",
    "1.2.2.n	With a cytochrome as acceptor",
    "1.2.3.-	With oxygen as acceptor",
    "1.2.3.n	With oxygen as acceptor",
    "1.2.4.-	With a disulfide as acceptor",
    "1.2.4.n	With a disulfide as acceptor",
    "1.2.5.-	With a quinone or similar compound as acceptor",
    "1.2.5.n	With a quinone or similar compound as acceptor",
    "1.2.7.-	With an iron-sulfur protein as acceptor",
    "1.2.7.n	With an iron-sulfur protein as acceptor",
    "1.2.98.-	With other, known, acceptors",
    "1.2.98.n	With other, known, acceptors",
    "1.2.99.-	With other acceptors",
    "1.2.99.n	With other acceptors",
    "1.3.-.-	Acting on the CH-CH group of donors",
    "1.3.n.n	Acting on the CH-CH group of donors",
    "1.3.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.3.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.3.2.-	With a cytochrome as acceptor",
    "1.3.2.n	With a cytochrome as acceptor",
    "1.3.3.-	With oxygen as acceptor",
    "1.3.3.n	With oxygen as acceptor",
    "1.3.5.-	With a quinone or related compound as acceptor",
    "1.3.5.n	With a quinone or related compound as acceptor",
    "1.3.7.-	With an iron-sulfur protein as acceptor",
    "1.3.7.n	With an iron-sulfur protein as acceptor",
    "1.3.8.-	With a flavin as acceptor",
    "1.3.8.n	With a flavin as acceptor",
    "1.3.98.-	With other, known, acceptors",
    "1.3.98.n	With other, known, acceptors",
    "1.3.99.-	With other acceptors",
    "1.3.99.n	With other acceptors",
    "1.4.-.-	Acting on the CH-NH(2) group of donors",
    "1.4.n.n	Acting on the CH-NH(2) group of donors",
    "1.4.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.4.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.4.2.-	With a cytochrome as acceptor",
    "1.4.2.n	With a cytochrome as acceptor",
    "1.4.3.-	With oxygen as acceptor",
    "1.4.3.n	With oxygen as acceptor",
    "1.4.4.-	With a disulfide as acceptor",
    "1.4.4.n	With a disulfide as acceptor",
    "1.4.5.-	With a quinone or similar compound as acceptor",
    "1.4.5.n	With a quinone or similar compound as acceptor",
    "1.4.7.-	With an iron-sulfur protein as acceptor",
    "1.4.7.n	With an iron-sulfur protein as acceptor",
    "1.4.9.-	With a copper protein as acceptor",
    "1.4.9.n	With a copper protein as acceptor",
    "1.4.98.-	With other, known, acceptors",
    "1.4.98.n	With other, known, acceptors",
    "1.4.99.-	With other acceptors",
    "1.4.99.n	With other acceptors",
    "1.5.-.-	Acting on the CH-NH group of donors",
    "1.5.n.n	Acting on the CH-NH group of donors",
    "1.5.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.5.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.5.3.-	With oxygen as acceptor",
    "1.5.3.n	With oxygen as acceptor",
    "1.5.4.-	With a disulfide as acceptor",
    "1.5.4.n	With a disulfide as acceptor",
    "1.5.5.-	With a quinone or similar compound as acceptor",
    "1.5.5.n	With a quinone or similar compound as acceptor",
    "1.5.7.-	With an iron-sulfur protein as acceptor",
    "1.5.7.n	With an iron-sulfur protein as acceptor",
    "1.5.8.-	With a flavin as acceptor",
    "1.5.8.n	With a flavin as acceptor",
    "1.5.98.-	With other, known, acceptors",
    "1.5.98.n	With other, known, acceptors",
    "1.5.99.-	With other acceptors",
    "1.5.99.n	With other acceptors",
    "1.6.-.-	Acting on NADH or NADPH",
    "1.6.n.n	Acting on NADH or NADPH",
    "1.6.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.6.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.6.2.-	With a heme protein as acceptor",
    "1.6.2.n	With a heme protein as acceptor",
    "1.6.3.-	With a oxygen as acceptor",
    "1.6.3.n	With a oxygen as acceptor",
    "1.6.5.-	With a quinone or similar compound as acceptor",
    "1.6.5.n	With a quinone or similar compound as acceptor",
    "1.6.6.-	With a nitrogenous group as acceptor",
    "1.6.6.n	With a nitrogenous group as acceptor",
    "1.6.99.-	With other acceptors",
    "1.6.99.n	With other acceptors",
    "1.7.-.-	Acting on other nitrogenous compounds as donors",
    "1.7.n.n	Acting on other nitrogenous compounds as donors",
    "1.7.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.7.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.7.2.-	With a cytochrome as acceptor",
    "1.7.2.n	With a cytochrome as acceptor",
    "1.7.3.-	With oxygen as acceptor",
    "1.7.3.n	With oxygen as acceptor",
    "1.7.5.-	With a quinone or similar compound as acceptor",
    "1.7.5.n	With a quinone or similar compound as acceptor",
    "1.7.6.-	With a nitrogenous group as acceptor",
    "1.7.6.n	With a nitrogenous group as acceptor",
    "1.7.7.-	With an iron-sulfur protein as acceptor",
    "1.7.7.n	With an iron-sulfur protein as acceptor",
    "1.7.9.-	With a copper protein as acceptor",
    "1.7.9.n	With a copper protein as acceptor",
    "1.7.99.-	With other acceptors",
    "1.7.99.n	With other acceptors",
    "1.8.-.-	Acting on a sulfur group of donors",
    "1.8.n.n	Acting on a sulfur group of donors",
    "1.8.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.8.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.8.2.-	With a cytochrome as acceptor",
    "1.8.2.n	With a cytochrome as acceptor",
    "1.8.3.-	With oxygen as acceptor",
    "1.8.3.n	With oxygen as acceptor",
    "1.8.4.-	With a disulfide as acceptor",
    "1.8.4.n	With a disulfide as acceptor",
    "1.8.5.-	With a quinone or similar compound as acceptor",
    "1.8.5.n	With a quinone or similar compound as acceptor",
    "1.8.7.-	With an iron-sulfur protein as acceptor",
    "1.8.7.n	With an iron-sulfur protein as acceptor",
    "1.8.98.-	With other, known, acceptors",
    "1.8.98.n	With other, known, acceptors",
    "1.8.99.-	With other acceptors",
    "1.8.99.n	With other acceptors",
    "1.9.-.-	Acting on a heme group of donors",
    "1.9.n.n	Acting on a heme group of donors",
    "1.9.3.-	With oxygen as acceptor",
    "1.9.3.n	With oxygen as acceptor",
    "1.9.6.-	With a nitrogenous group as acceptor",
    "1.9.6.n	With a nitrogenous group as acceptor",
    "1.9.98.-	With other, known, acceptors",
    "1.9.98.n	With other, known, acceptors",
    "1.9.99.-	With other acceptors",
    "1.9.99.n	With other acceptors",
    "1.10.-.-	Acting on diphenols and related substances as donors",
    "1.10.n.n	Acting on diphenols and related substances as donors",
    "1.10.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.10.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.10.2.-	With a cytochrome as acceptor",
    "1.10.2.n	With a cytochrome as acceptor",
    "1.10.3.-	With oxygen as acceptor",
    "1.10.3.n	With oxygen as acceptor",
    "1.10.9.-	With a copper protein as acceptor",
    "1.10.9.n	With a copper protein as acceptor",
    "1.10.98.-	With other, known, acceptors",
    "1.10.98.n	With other, known, acceptors",
    "1.10.99.-	With other acceptors",
    "1.10.99.n	With other acceptors",
    "1.11.-.-	Acting on a peroxide as acceptor",
    "1.11.n.n	Acting on a peroxide as acceptor",
    "1.11.1.-	Peroxidases",
    "1.11.1.n	Peroxidases",
    "1.11.2.-	With H(2)O(2) as acceptor, one oxygen atom of which is incorporated into the product",
    "1.11.2.n	With H(2)O(2) as acceptor, one oxygen atom of which is incorporated into the product",
    "1.12.-.-	Acting on hydrogen as donor",
    "1.12.n.n	Acting on hydrogen as donor",
    "1.12.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.12.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.12.2.-	With a cytochrome as acceptor",
    "1.12.2.n	With a cytochrome as acceptor",
    "1.12.5.-	With a quinone or similar compound as acceptor",
    "1.12.5.n	With a quinone or similar compound as acceptor",
    "1.12.7.-	With an iron-sulfur protein as acceptor",
    "1.12.7.n	With an iron-sulfur protein as acceptor",
    "1.12.98.-	With other known acceptors",
    "1.12.98.n	With other known acceptors",
    "1.12.99.-	With other acceptors",
    "1.12.99.n	With other acceptors",
    "1.13.-.-	Acting on single donors with incorporation of molecular oxygen",
    "1.13.n.n	Acting on single donors with incorporation of molecular oxygen",
    "1.13.11.-	With incorporation of two atoms of oxygen",
    "1.13.11.n	With incorporation of two atoms of oxygen",
    "1.13.12.-	With incorporation of one atom of oxygen",
    "1.13.12.n	With incorporation of one atom of oxygen",
    "1.13.99.-	Miscellaneous (requires further characterization)",
    "1.13.99.n	Miscellaneous (requires further characterization)",
    "1.14.-.-	Acting on paired donors, with incorporation or reduction of molecular oxygen",
    "1.14.n.n	Acting on paired donors, with incorporation or reduction of molecular oxygen",
    "1.14.11.-	With 2-oxoglutarate as one donor, and incorporation of one atom each of oxygen into both donors",
    "1.14.11.n	With 2-oxoglutarate as one donor, and incorporation of one atom each of oxygen into both donors",
    "1.14.12.-	With NADH or NADPH as one donor, and incorporation of two atoms of oxygen into one donor",
    "1.14.12.n	With NADH or NADPH as one donor, and incorporation of two atoms of oxygen into one donor",
    "1.14.13.-	With NADH or NADPH as one donor, and incorporation of one atom of oxygen",
    "1.14.13.n	With NADH or NADPH as one donor, and incorporation of one atom of oxygen",
    "1.14.14.-	With reduced flavin or flavoprotein as one donor, and incorporation of one atom of oxygen",
    "1.14.14.n	With reduced flavin or flavoprotein as one donor, and incorporation of one atom of oxygen",
    "1.14.15.-	With a reduced iron-sulfur protein as one donor, and incorporation of one atom of oxygen",
    "1.14.15.n	With a reduced iron-sulfur protein as one donor, and incorporation of one atom of oxygen",
    "1.14.16.-	With reduced pteridine as one donor, and incorporation of one atom of oxygen",
    "1.14.16.n	With reduced pteridine as one donor, and incorporation of one atom of oxygen",
    "1.14.17.-	With reduced ascorbate as one donor, and incorporation of one atom of oxygen",
    "1.14.17.n	With reduced ascorbate as one donor, and incorporation of one atom of oxygen",
    "1.14.18.-	With another compound as one donor, and incorporation of one atom of oxygen",
    "1.14.18.n	With another compound as one donor, and incorporation of one atom of oxygen",
    "1.14.19.-	With oxidation of a pair of donors resulting in the reduction of molecular oxygen to two molecules of water",
    "1.14.19.n	With oxidation of a pair of donors resulting in the reduction of molecular oxygen to two molecules of water",
    "1.14.20.-	With 2-oxoglutarate as one donor, and the other dehydrogenated",
    "1.14.20.n	With 2-oxoglutarate as one donor, and the other dehydrogenated",
    "1.14.21.-	With NADH or NADPH as one donor, and the other dehydrogenated",
    "1.14.21.n	With NADH or NADPH as one donor, and the other dehydrogenated",
    "1.14.99.-	Miscellaneous (requires further characterization)",
    "1.14.99.n	Miscellaneous (requires further characterization)",
    "1.15.-.-	Acting on superoxide as acceptor",
    "1.15.n.n	Acting on superoxide as acceptor",
    "1.15.1.-	Acting on superoxide as acceptor",
    "1.15.1.n	Acting on superoxide as acceptor",
    "1.16.-.-	Oxidizing metal ions",
    "1.16.n.n	Oxidizing metal ions",
    "1.16.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.16.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.16.3.-	With oxygen as acceptor",
    "1.16.3.n	With oxygen as acceptor",
    "1.16.5.-	With a quinone or similar compound as acceptor",
    "1.16.5.n	With a quinone or similar compound as acceptor",
    "1.16.8.-	With flavin as acceptor",
    "1.16.8.n	With flavin as acceptor",
    "1.16.9.-	With a copper protein as acceptor",
    "1.16.9.n	With a copper protein as acceptor",
    "1.16.98.-	With other known acceptors",
    "1.16.98.n	With other known acceptors",
    "1.17.-.-	Acting on CH or CH(2) groups",
    "1.17.n.n	Acting on CH or CH(2) groups",
    "1.17.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.17.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.17.2.-	With a cytochrome as acceptor",
    "1.17.2.n	With a cytochrome as acceptor",
    "1.17.3.-	With oxygen as acceptor",
    "1.17.3.n	With oxygen as acceptor",
    "1.17.4.-	With a disulfide as acceptor",
    "1.17.4.n	With a disulfide as acceptor",
    "1.17.5.-	With a quinone or similar compound as acceptor",
    "1.17.5.n	With a quinone or similar compound as acceptor",
    "1.17.7.-	With an iron-sulfur protein as acceptor",
    "1.17.7.n	With an iron-sulfur protein as acceptor",
    "1.17.99.-	With other acceptors",
    "1.17.99.n	With other acceptors",
    "1.18.-.-	Acting on iron-sulfur proteins as donors",
    "1.18.n.n	Acting on iron-sulfur proteins as donors",
    "1.18.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.18.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.18.6.-	With dinitrogen as acceptor",
    "1.18.6.n	With dinitrogen as acceptor",
    "1.19.-.-	Acting on reduced flavodoxin as donor",
    "1.19.n.n	Acting on reduced flavodoxin as donor",
    "1.19.6.-	With dinitrogen as acceptor",
    "1.19.6.n	With dinitrogen as acceptor",
    "1.20.-.-	Acting on phosphorus or arsenic in donors",
    "1.20.n.n	Acting on phosphorus or arsenic in donors",
    "1.20.1.-	With NAD(P)(+) as acceptor",
    "1.20.1.n	With NAD(P)(+) as acceptor",
    "1.20.2.-	With a cytochrome as acceptor",
    "1.20.2.n	With a cytochrome as acceptor",
    "1.20.4.-	With disulfide as acceptor",
    "1.20.4.n	With disulfide as acceptor",
    "1.20.9.-	With a copper protein as acceptor",
    "1.20.9.n	With a copper protein as acceptor",
    "1.20.98.-	With other, known acceptors",
    "1.20.98.n	With other, known acceptors",
    "1.20.99.-	With other acceptors",
    "1.20.99.n	With other acceptors",
    "1.21.-.-	Acting on x-H and y-H to form an x-y bond",
    "1.21.n.n	Acting on x-H and y-H to form an x-y bond",
    "1.21.3.-	With oxygen as acceptor",
    "1.21.3.n	With oxygen as acceptor",
    "1.21.4.-	With a disulfide as acceptor",
    "1.21.4.n	With a disulfide as acceptor",
    "1.21.99.-	With other acceptors",
    "1.21.99.n	With other acceptors",
    "1.22.-.-	Acting on halogen in donors",
    "1.22.n.n	Acting on halogen in donors",
    "1.22.1.-	With NAD(+) or NADP(+) as acceptor",
    "1.22.1.n	With NAD(+) or NADP(+) as acceptor",
    "1.23.-.-	Reducing C-O-C group as acceptor",
    "1.23.n.n	Reducing C-O-C group as acceptor",
    "1.23.1.-	With NADH or NADPH as donor",
    "1.23.1.n	With NADH or NADPH as donor",
    "1.97.-.-	Other oxidoreductases",
    "1.97.n.n	Other oxidoreductases",
    "1.97.1.-	Sole sub-subclass for oxidoreductases that do not belong in the other subclasses",
    "1.97.1.n	Sole sub-subclass for oxidoreductases that do not belong in the other subclasses",
    "2.-.-.-	Transferases",
    "2.n.n.n	Transferases",
    "2.1.-.-	Transferring one-carbon groups",
    "2.1.n.n	Transferring one-carbon groups",
    "2.1.1.-	Methyltransferases",
    "2.1.1.n	Methyltransferases",
    "2.1.2.-	Hydroxymethyl-, formyl- and related transferases",
    "2.1.2.n	Hydroxymethyl-, formyl- and related transferases",
    "2.1.3.-	Carboxyl- and carbamoyltransferases",
    "2.1.3.n	Carboxyl- and carbamoyltransferases",
    "2.1.4.-	Amidinotransferases",
    "2.1.4.n	Amidinotransferases",
    "2.2.-.-	Transferring aldehyde or ketone residues",
    "2.2.n.n	Transferring aldehyde or ketone residues",
    "2.2.1.-	Transketolases and transaldolases",
    "2.2.1.n	Transketolases and transaldolases",
    "2.3.-.-	Acyltransferases",
    "2.3.n.n	Acyltransferases",
    "2.3.1.-	Transferring groups other than amino-acyl groups",
    "2.3.1.n	Transferring groups other than amino-acyl groups",
    "2.3.2.-	Aminoacyltransferases",
    "2.3.2.n	Aminoacyltransferases",
    "2.3.3.-	Acyl groups converted into alkyl on transfer",
    "2.3.3.n	Acyl groups converted into alkyl on transfer",
    "2.4.-.-	Glycosyltransferases",
    "2.4.n.n	Glycosyltransferases",
    "2.4.1.-	Hexosyltransferases",
    "2.4.1.n	Hexosyltransferases",
    "2.4.2.-	Pentosyltransferases",
    "2.4.2.n	Pentosyltransferases",
    "2.4.99.-	Transferring other glycosyl groups",
    "2.4.99.n	Transferring other glycosyl groups",
    "2.5.-.-	Transferring alkyl or aryl groups, other than methyl groups",
    "2.5.n.n	Transferring alkyl or aryl groups, other than methyl groups",
    "2.5.1.-	Transferring alkyl or aryl groups, other than methyl groups",
    "2.5.1.n	Transferring alkyl or aryl groups, other than methyl groups",
    "2.6.-.-	Transferring nitrogenous groups",
    "2.6.n.n	Transferring nitrogenous groups",
    "2.6.1.-	Transaminases (aminotransferases)",
    "2.6.1.n	Transaminases (aminotransferases)",
    "2.6.3.-	Oximinotransferases",
    "2.6.3.n	Oximinotransferases",
    "2.6.99.-	Transferring other nitrogenous groups",
    "2.6.99.n	Transferring other nitrogenous groups",
    "2.7.-.-	Transferring phosphorous-containing groups",
    "2.7.n.n	Transferring phosphorous-containing groups",
    "2.7.1.-	Phosphotransferases with an alcohol group as acceptor",
    "2.7.1.n	Phosphotransferases with an alcohol group as acceptor",
    "2.7.2.-	Phosphotransferases with a carboxyl group as acceptor",
    "2.7.2.n	Phosphotransferases with a carboxyl group as acceptor",
    "2.7.3.-	Phosphotransferases with a nitrogenous group as acceptor",
    "2.7.3.n	Phosphotransferases with a nitrogenous group as acceptor",
    "2.7.4.-	Phosphotransferases with a phosphate group as acceptor",
    "2.7.4.n	Phosphotransferases with a phosphate group as acceptor",
    "2.7.6.-	Diphosphotransferases",
    "2.7.6.n	Diphosphotransferases",
    "2.7.7.-	Nucleotidyltransferases",
    "2.7.7.n	Nucleotidyltransferases",
    "2.7.8.-	Transferases for other substituted phosphate groups",
    "2.7.8.n	Transferases for other substituted phosphate groups",
    "2.7.9.-	Phosphotransferases with paired acceptors",
    "2.7.9.n	Phosphotransferases with paired acceptors",
    "2.7.10.-	Protein-tyrosine kinases",
    "2.7.10.n	Protein-tyrosine kinases",
    "2.7.11.-	Protein-serine/threonine kinases",
    "2.7.11.n	Protein-serine/threonine kinases",
    "2.7.12.-	Dual-specificity kinases (those acting on Ser/Thr and Tyr residues)",
    "2.7.12.n	Dual-specificity kinases (those acting on Ser/Thr and Tyr residues)",
    "2.7.13.-	Protein-histidine kinases",
    "2.7.13.n	Protein-histidine kinases",
    "2.7.99.-	Other protein kinases",
    "2.7.99.n	Other protein kinases",
    "2.8.-.-	Transferring sulfur-containing groups",
    "2.8.n.n	Transferring sulfur-containing groups",
    "2.8.1.-	Sulfurtransferases",
    "2.8.1.n	Sulfurtransferases",
    "2.8.2.-	Sulfotransferases",
    "2.8.2.n	Sulfotransferases",
    "2.8.3.-	CoA-transferases",
    "2.8.3.n	CoA-transferases",
    "2.8.4.-	Transferring alkylthio groups",
    "2.8.4.n	Transferring alkylthio groups",
    "2.9.-.-	Transferring selenium-containing groups",
    "2.9.n.n	Transferring selenium-containing groups",
    "2.9.1.-	Selenotransferases",
    "2.9.1.n	Selenotransferases",
    "2.10.-.-	Transferring molybdenum- or tungsten-containing groups",
    "2.10.n.n	Transferring molybdenum- or tungsten-containing groups",
    "2.10.1.-	Molybdenumtransferases or tungstentransferases with sulfide groups as acceptors",
    "2.10.1.n	Molybdenumtransferases or tungstentransferases with sulfide groups as acceptors",
    "3.-.-.-	Hydrolases",
    "3.n.n.n	Hydrolases",
    "3.1.-.-	Acting on ester bonds",
    "3.1.n.n	Acting on ester bonds",
    "3.1.1.-	Carboxylic ester hydrolases",
    "3.1.1.n	Carboxylic ester hydrolases",
    "3.1.2.-	Thiolester hydrolases",
    "3.1.2.n	Thiolester hydrolases",
    "3.1.3.-	Phosphoric monoester hydrolases",
    "3.1.3.n	Phosphoric monoester hydrolases",
    "3.1.4.-	Phosphoric diester hydrolases",
    "3.1.4.n	Phosphoric diester hydrolases",
    "3.1.5.-	Triphosphoric monoester hydrolases",
    "3.1.5.n	Triphosphoric monoester hydrolases",
    "3.1.6.-	Sulfuric ester hydrolases",
    "3.1.6.n	Sulfuric ester hydrolases",
    "3.1.7.-	Diphosphoric monoester hydrolases",
    "3.1.7.n	Diphosphoric monoester hydrolases",
    "3.1.8.-	Phosphoric triester hydrolases",
    "3.1.8.n	Phosphoric triester hydrolases",
    "3.1.11.-	Exodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.11.n	Exodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.13.-	Exoribonucleases producing 5'-phosphomonoesters",
    "3.1.13.n	Exoribonucleases producing 5'-phosphomonoesters",
    "3.1.14.-	Exoribonucleases producing 3'-phosphomonoesters",
    "3.1.14.n	Exoribonucleases producing 3'-phosphomonoesters",
    "3.1.15.-	Exonucleases active with either ribo- or deoxyribonucleic acid and producing 5'-phosphomonoesters",
    "3.1.15.n	Exonucleases active with either ribo- or deoxyribonucleic acid and producing 5'-phosphomonoesters",
    "3.1.16.-	Exonucleases active with either ribo- or deoxyribonucleic acid and producing 3'-phosphomonoesters",
    "3.1.16.n	Exonucleases active with either ribo- or deoxyribonucleic acid and producing 3'-phosphomonoesters",
    "3.1.21.-	Endodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.21.n	Endodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.22.-	Endodeoxyribonucleases producing other than 5'-phosphomonoesters",
    "3.1.22.n	Endodeoxyribonucleases producing other than 5'-phosphomonoesters",
    "3.1.25.-	Site-specific endodeoxyribonucleases specific for altered bases",
    "3.1.25.n	Site-specific endodeoxyribonucleases specific for altered bases",
    "3.1.26.-	Endoribonucleases producing 5'-phosphomonoesters",
    "3.1.26.n	Endoribonucleases producing 5'-phosphomonoesters",
    "3.1.27.-	Endoribonucleases producing other than 5'-phosphomonoesters",
    "3.1.27.n	Endoribonucleases producing other than 5'-phosphomonoesters",
    "3.1.30.-	Endoribonucleases active with either ribo- or deoxyribonucleic acid and producing 5'-phosphomonoesters",
    "3.1.30.n	Endoribonucleases active with either ribo- or deoxyribonucleic acid and producing 5'-phosphomonoesters",
    "3.1.31.-	Endoribonucleases active with either ribo- or deoxyribonucleic acid and producing 3'-phosphomonoesters",
    "3.1.31.n	Endoribonucleases active with either ribo- or deoxyribonucleic acid and producing 3'-phosphomonoesters",
    "3.2.-.-	Glycosylases",
    "3.2.n.n	Glycosylases",
    "3.2.1.-	Glycosidases, i.e. enzymes hydrolyzing O- and S-glycosyl compounds",
    "3.2.1.n	Glycosidases, i.e. enzymes hydrolyzing O- and S-glycosyl compounds",
    "3.2.2.-	Hydrolyzing N-glycosyl compounds",
    "3.2.2.n	Hydrolyzing N-glycosyl compounds",
    "3.3.-.-	Acting on ether bonds",
    "3.3.n.n	Acting on ether bonds",
    "3.3.1.-	Thioether and trialkylsulfonium hydrolases",
    "3.3.1.n	Thioether and trialkylsulfonium hydrolases",
    "3.3.2.-	Ether hydrolases",
    "3.3.2.n	Ether hydrolases",
    "3.4.-.-	Acting on peptide bonds (peptide hydrolases)",
    "3.4.n.n	Acting on peptide bonds (peptide hydrolases)",
    "3.4.11.-	Aminopeptidases",
    "3.4.11.n	Aminopeptidases",
    "3.4.13.-	Dipeptidases",
    "3.4.13.n	Dipeptidases",
    "3.4.14.-	Dipeptidyl-peptidases and tripeptidyl-peptidases",
    "3.4.14.n	Dipeptidyl-peptidases and tripeptidyl-peptidases",
    "3.4.15.-	Peptidyl-dipeptidases",
    "3.4.15.n	Peptidyl-dipeptidases",
    "3.4.16.-	Serine-type carboxypeptidases",
    "3.4.16.n	Serine-type carboxypeptidases",
    "3.4.17.-	Metallocarboxypeptidases",
    "3.4.17.n	Metallocarboxypeptidases",
    "3.4.18.-	Cysteine-type carboxypeptidases",
    "3.4.18.n	Cysteine-type carboxypeptidases",
    "3.4.19.-	Omega peptidases",
    "3.4.19.n	Omega peptidases",
    "3.4.21.-	Serine endopeptidases",
    "3.4.21.n	Serine endopeptidases",
    "3.4.22.-	Cysteine endopeptidases",
    "3.4.22.n	Cysteine endopeptidases",
    "3.4.23.-	Aspartic endopeptidases",
    "3.4.23.n	Aspartic endopeptidases",
    "3.4.24.-	Metalloendopeptidases",
    "3.4.24.n	Metalloendopeptidases",
    "3.4.25.-	Threonine endopeptidases",
    "3.4.25.n	Threonine endopeptidases",
    "3.4.99.-	Endopeptidases of unknown catalytic mechanism",
    "3.4.99.n	Endopeptidases of unknown catalytic mechanism",
    "3.5.-.-	Acting on carbon-nitrogen bonds, other than peptide bonds",
    "3.5.n.n	Acting on carbon-nitrogen bonds, other than peptide bonds",
    "3.5.1.-	In linear amides",
    "3.5.1.n	In linear amides",
    "3.5.2.-	In cyclic amides",
    "3.5.2.n	In cyclic amides",
    "3.5.3.-	In linear amidines",
    "3.5.3.n	In linear amidines",
    "3.5.4.-	In cyclic amidines",
    "3.5.4.n	In cyclic amidines",
    "3.5.5.-	In nitriles",
    "3.5.5.n	In nitriles",
    "3.5.99.-	In other compounds",
    "3.5.99.n	In other compounds",
    "3.6.-.-	Acting on acid anhydrides",
    "3.6.n.n	Acting on acid anhydrides",
    "3.6.1.-	In phosphorous-containing anhydrides",
    "3.6.1.n	In phosphorous-containing anhydrides",
    "3.6.2.-	In sulfonyl-containing anhydrides",
    "3.6.2.n	In sulfonyl-containing anhydrides",
    "3.6.3.-	Acting on acid anhydrides; catalyzing transmembrane movement of substances",
    "3.6.3.n	Acting on acid anhydrides; catalyzing transmembrane movement of substances",
    "3.6.4.-	Acting on acid anhydrides; involved in cellular and subcellular movement",
    "3.6.4.n	Acting on acid anhydrides; involved in cellular and subcellular movement",
    "3.6.5.-	Acting on GTP; involved in cellular and subcellular movement",
    "3.6.5.n	Acting on GTP; involved in cellular and subcellular movement",
    "3.7.-.-	Acting on carbon-carbon bonds",
    "3.7.n.n	Acting on carbon-carbon bonds",
    "3.7.1.-	In ketonic substances",
    "3.7.1.n	In ketonic substances",
    "3.8.-.-	Acting on halide bonds",
    "3.8.n.n	Acting on halide bonds",
    "3.8.1.-	In C-halide compounds",
    "3.8.1.n	In C-halide compounds",
    "3.9.-.-	Acting on phosphorus-nitrogen bonds",
    "3.9.n.n	Acting on phosphorus-nitrogen bonds",
    "3.9.1.-	Acting on phosphorus-nitrogen bonds",
    "3.9.1.n	Acting on phosphorus-nitrogen bonds",
    "3.10.-.-	Acting on sulfur-nitrogen bonds",
    "3.10.n.n	Acting on sulfur-nitrogen bonds",
    "3.10.1.-	Acting on sulfur-nitrogen bonds",
    "3.10.1.n	Acting on sulfur-nitrogen bonds",
    "3.11.-.-	Acting on carbon-phosphorus bonds",
    "3.11.n.n	Acting on carbon-phosphorus bonds",
    "3.11.1.-	Acting on carbon-phosphorus bonds",
    "3.11.1.n	Acting on carbon-phosphorus bonds",
    "3.12.-.-	Acting on sulfur-sulfur bonds",
    "3.12.n.n	Acting on sulfur-sulfur bonds",
    "3.12.1.-	Acting on sulfur-sulfur bonds",
    "3.12.1.n	Acting on sulfur-sulfur bonds",
    "3.13.-.-	Acting on carbon-sulfur bonds",
    "3.13.n.n	Acting on carbon-sulfur bonds",
    "3.13.1.-	Acting on carbon-sulfur bonds",
    "3.13.1.n	Acting on carbon-sulfur bonds",
    "4.-.-.-	Lyases",
    "4.n.n.n	Lyases",
    "4.1.-.-	Carbon-carbon lyases",
    "4.1.n.n	Carbon-carbon lyases",
    "4.1.1.-	Carboxy-lyases",
    "4.1.1.n	Carboxy-lyases",
    "4.1.2.-	Aldehyde-lyases",
    "4.1.2.n	Aldehyde-lyases",
    "4.1.3.-	Oxo-acid-lyases",
    "4.1.3.n	Oxo-acid-lyases",
    "4.1.99.-	Other carbon-carbon lyases",
    "4.1.99.n	Other carbon-carbon lyases",
    "4.2.-.-	Carbon-oxygen lyases",
    "4.2.n.n	Carbon-oxygen lyases",
    "4.2.1.-	Hydro-lyases",
    "4.2.1.n	Hydro-lyases",
    "4.2.2.-	Acting on polysaccharides",
    "4.2.2.n	Acting on polysaccharides",
    "4.2.3.-	Acting on phosphates",
    "4.2.3.n	Acting on phosphates",
    "4.2.99.-	Other carbon-oxygen lyases",
    "4.2.99.n	Other carbon-oxygen lyases",
    "4.3.-.-	Carbon-nitrogen lyases",
    "4.3.n.n	Carbon-nitrogen lyases",
    "4.3.1.-	Ammonia-lyases",
    "4.3.1.n	Ammonia-lyases",
    "4.3.2.-	Lyases acting on amides, amidines, etc",
    "4.3.2.n	Lyases acting on amides, amidines, etc",
    "4.3.3.-	Amine-lyases",
    "4.3.3.n	Amine-lyases",
    "4.3.99.-	Other carbon-nitrogen lyases",
    "4.3.99.n	Other carbon-nitrogen lyases",
    "4.4.-.-	Carbon-sulfur lyases",
    "4.4.n.n	Carbon-sulfur lyases",
    "4.4.1.-	Carbon-sulfur lyases",
    "4.4.1.n	Carbon-sulfur lyases",
    "4.5.-.-	Carbon-halide lyases",
    "4.5.n.n	Carbon-halide lyases",
    "4.5.1.-	Carbon-halide lyases",
    "4.5.1.n	Carbon-halide lyases",
    "4.6.-.-	Phosphorus-oxygen lyases",
    "4.6.n.n	Phosphorus-oxygen lyases",
    "4.6.1.-	Phosphorus-oxygen lyases",
    "4.6.1.n	Phosphorus-oxygen lyases",
    "4.7.-.-	Carbon-phosphorus lyases",
    "4.7.n.n	Carbon-phosphorus lyases",
    "4.7.1.-	Carbon-phosphorus lyases",
    "4.7.1.n	Carbon-phosphorus lyases",
    "4.99.-.-	Other lyases",
    "4.99.n.n	Other lyases",
    "4.99.1.-	Sole sub-subclass for lyases that do not belong in the other subclasses",
    "4.99.1.n	Sole sub-subclass for lyases that do not belong in the other subclasses",
    "5.-.-.-	Isomerases",
    "5.n.n.n	Isomerases",
    "5.1.-.-	Racemases and epimerases",
    "5.1.n.n	Racemases and epimerases",
    "5.1.1.-	Acting on amino acids and derivatives",
    "5.1.1.n	Acting on amino acids and derivatives",
    "5.1.2.-	Acting on hydroxy acids and derivatives",
    "5.1.2.n	Acting on hydroxy acids and derivatives",
    "5.1.3.-	Acting on carbohydrates and derivatives",
    "5.1.3.n	Acting on carbohydrates and derivatives",
    "5.1.99.-	Acting on other compounds",
    "5.1.99.n	Acting on other compounds",
    "5.2.-.-	Cis-trans-isomerases",
    "5.2.n.n	Cis-trans-isomerases",
    "5.2.1.-	Cis-trans Isomerases",
    "5.2.1.n	Cis-trans Isomerases",
    "5.3.-.-	Intramolecular oxidoreductases",
    "5.3.n.n	Intramolecular oxidoreductases",
    "5.3.1.-	Interconverting aldoses and ketoses, and related compounds",
    "5.3.1.n	Interconverting aldoses and ketoses, and related compounds",
    "5.3.2.-	Interconverting keto- and enol- groups",
    "5.3.2.n	Interconverting keto- and enol- groups",
    "5.3.3.-	Transposing C==C bonds",
    "5.3.3.n	Transposing C==C bonds",
    "5.3.4.-	Transposing S-S bonds",
    "5.3.4.n	Transposing S-S bonds",
    "5.3.99.-	Other intramolecular oxidoreductases",
    "5.3.99.n	Other intramolecular oxidoreductases",
    "5.4.-.-	Intramolecular transferases (mutases)",
    "5.4.n.n	Intramolecular transferases (mutases)",
    "5.4.1.-	Transferring acyl groups",
    "5.4.1.n	Transferring acyl groups",
    "5.4.2.-	Phosphotransferases (phosphomutases)",
    "5.4.2.n	Phosphotransferases (phosphomutases)",
    "5.4.3.-	Transferring amino groups",
    "5.4.3.n	Transferring amino groups",
    "5.4.4.-	Transferring hydroxy groups",
    "5.4.4.n	Transferring hydroxy groups",
    "5.4.99.-	Transferring other groups",
    "5.4.99.n	Transferring other groups",
    "5.5.-.-	Intramolecular lyases",
    "5.5.n.n	Intramolecular lyases",
    "5.5.1.-	Intramolecular lyases",
    "5.5.1.n	Intramolecular lyases",
    "5.99.-.-	Other isomerases",
    "5.99.n.n	Other isomerases",
    "5.99.1.-	Sole sub-subclass for isomerases that do not belong in the other subclasses",
    "5.99.1.n	Sole sub-subclass for isomerases that do not belong in the other subclasses",
    "6.-.-.-	Ligases",
    "6.n.n.n	Ligases",
    "6.1.-.-	Forming carbon-oxygen bonds",
    "6.1.n.n	Forming carbon-oxygen bonds",
    "6.1.1.-	Ligases forming aminoacyl-tRNA and related compounds",
    "6.1.1.n	Ligases forming aminoacyl-tRNA and related compounds",
    "6.1.2.-	Acid--alcohol ligases (ester synthases)",
    "6.1.2.n	Acid--alcohol ligases (ester synthases)",
    "6.2.-.-	Forming carbon-sulfur bonds",
    "6.2.n.n	Forming carbon-sulfur bonds",
    "6.2.1.-	Acid--thiol ligases",
    "6.2.1.n	Acid--thiol ligases",
    "6.3.-.-	Forming carbon-nitrogen bonds",
    "6.3.n.n	Forming carbon-nitrogen bonds",
    "6.3.1.-	Acid--ammonia (or amide) ligases (amide synthases)",
    "6.3.1.n	Acid--ammonia (or amide) ligases (amide synthases)",
    "6.3.2.-	Acid--amino-acid ligases (peptide synthases)",
    "6.3.2.n	Acid--amino-acid ligases (peptide synthases)",
    "6.3.3.-	Cyclo-ligases",
    "6.3.3.n	Cyclo-ligases",
    "6.3.4.-	Other carbon--nitrogen ligases",
    "6.3.4.n	Other carbon--nitrogen ligases",
    "6.3.5.-	Carbon--nitrogen ligases with glutamine as amido-N-donor",
    "6.3.5.n	Carbon--nitrogen ligases with glutamine as amido-N-donor",
    "6.4.-.-	Forming carbon-carbon bonds",
    "6.4.n.n	Forming carbon-carbon bonds",
    "6.4.1.-	Ligases that form carbon-carbon bonds",
    "6.4.1.n	Ligases that form carbon-carbon bonds",
    "6.5.-.-	Forming phosphoric ester bonds",
    "6.5.n.n	Forming phosphoric ester bonds",
    "6.5.1.-	Ligases that form phosphoric-ester bonds",
    "6.5.1.n	Ligases that form phosphoric-ester bonds",
    "6.6.-.-	Forming nitrogen-metal bonds",
    "6.6.n.n	Forming nitrogen-metal bonds",
    "6.6.1.-	Forming coordination complexes",
    "6.6.1.n	Forming coordination complexes"
};
