#!/usr/bin/perl -w

# ngregtest.pl -- testing PCRE's on the fly
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: ngregtest.pl 626 2006-01-11 16:31:12Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use File::Basename;
use Getopt::Long;
use Pod::Usage;

use subs qw(print_help);
use vars qw($VERSION $PROGNAME);

$VERSION = '1.0';
$PROGNAME = basename($0);

my $opt_regex = undef;
my $opt_value = undef;
my $opt_help = undef;

Getopt::Long::Configure('bundling');
GetOptions (
	'h'			=> \$opt_help,
	'help'		=> \$opt_help,
	'r=s'		=> \$opt_regex,
	'regex=s'	=> \$opt_regex,
	'v=s'		=> \$opt_value,
	'value=s'	=> \$opt_value,
);

if ($opt_help) {
	print_help(undef, 99, 0);
}
elsif (defined $opt_regex && defined $opt_value) {
	if ($opt_value =~ m/$opt_regex/i) {
		print 'RegEX: m/'. $opt_regex. '/i'. "\n";
		print 'Value: '. $opt_value. "\n";
		
		my (@parts);
		for (my $i=1;$i<=10;$i++) {
			my $eval = eval('$'. $i);
			if ($eval) {
				push @parts, "Match (\$$i): $eval";
			}
		}
		
		if (scalar @parts > 0) {
			print join("\n", @parts), "\n";
		}
		
		print "\n";
	}
	else {
		print "$PROGNAME: Sorry, no match!\n";
	}
}
else {
	print_help("$PROGNAME: Too few options !!\n");
}

exit (0);

sub print_help {
	my ($message, $level, $exit) = @_;
	
	$level=1 unless (defined $level);
	$exit=0 unless (defined $exit);
	
	pod2usage(
		-exitstatus => $exit,
		-verbose => $level,
		-message => $message,
		-noperldoc => 1,
	);
}

__END__

=head1 NAME

ngregtest.pl - Testing Perl RegEX on the fly

=head1 SYNOPSIS

ngregtest.pl --regex=<PCRE> --value=<TEST_SAMPLE> [--help]

=head1 OPTIONS

=over 8

=item B<--help>

Prints a brief help description and exit.

=item B<--regex>

The regex e.g. ^.*?([a-zA-Z0-9 ]+)\n$

=item B<--value>

A little text, numbers or perfdata to test that the regex is working.

=back

=head1 DESCRIPTION

The programm is a little regextester shiped with NagiosGgrapher, if you
don't want read all the day the NG logfiles ;-) .

=head1 COPYRIGHT

ngregtest.pl, version 1.0, GPL v2 (c) 2006, NETWAYS GmbH
http://www.netways.de

NETWAYS GmbH, hereby disclaims all copyright
interest in the program `ngregtest'
(which makes passes at compilers) written 
by Marius Hein.

=cut
