#include "schemalistviewitem.h"
#include <qpixmap.h>
#include <qpainter.h>
#include "expand.xpm"
#include "collapse.xpm"

SchemaListViewItem::SchemaListViewItem(QListView *parent, SchemaListViewItem *sibling, const QString &title, const int flag, const QString &database, const QString &table, const QString &host, const QString &user)
	: QListViewItem(parent, sibling, title)
{
	this->flag = flag;
	this->database = database;
	this->table = table;
	this->host = host;
	this->user = user;

	if(flag == FLAG_TABLE)
		//setPixmap(1, QPixmap(expand_xpm));
		setText(1, "+");
}

SchemaListViewItem::SchemaListViewItem(SchemaListViewItem *parent, SchemaListViewItem *sibling, const QString &title, const int flag, const QString &database, const QString &table, const QString &host, const QString &user)
	: QListViewItem(parent, sibling, title)
{
	this->flag = flag;
	this->database = database;
	this->table = table;
	this->host = host;
	this->user = user;

	if(flag == FLAG_TABLE)
		//setPixmap(1, QPixmap(expand_xpm));
		setText(1, "+");
}

SchemaListViewItem::~SchemaListViewItem()
{
}

void SchemaListViewItem::paintCell(QPainter *z,const QColorGroup &color,int column,int width,int alignment)
{
	QColorGroup s(color);
	
	if(column == 0)
	{
		switch(flag)
		{
			case FLAG_DATABASE:
				s.setColor(QColorGroup::Text, Qt::red);
				break;
			case FLAG_TABLE:
				s.setColor(QColorGroup::Text, Qt::blue);
				break;
			case FLAG_FIELD:
				s.setColor(QColorGroup::Text, Qt::magenta);
				break;
			case FLAG_KEY:
				s.setColor(QColorGroup::Text, Qt::darkCyan);
				break;
			case FLAG_USER:
				s.setColor(QColorGroup::Text, Qt::red);
				break;
		}
	}
	
	QListViewItem::paintCell(z,s,column,width,alignment );
	//QListViewItem::paintCell(z,color,column,width,alignment );
}
