# Python 3.5 ast

import typing
from typing import Any, Union, Iterator

from _ast import (
    Add, alias, And, arg, arguments, Assert, Assign, AST, AsyncFor,
    AsyncFunctionDef, AsyncWith, Attribute, AugAssign, AugLoad, AugStore,
    Await, BinOp, BitAnd, BitOr, BitXor, BoolOp, boolop, Break, Bytes, Call,
    ClassDef, cmpop, Compare, comprehension, Continue, Del, Delete, Dict,
    DictComp, Div, Ellipsis, Eq, ExceptHandler, Expr, expr, Expression,
    expr_context, ExtSlice, FloorDiv, For, FunctionDef, GeneratorExp, Global,
    Gt, GtE, If, IfExp, Import, ImportFrom, In, Index, Interactive, Invert, Is,
    IsNot, keyword, Lambda, List, ListComp, Load, LShift, Lt, LtE, MatMult,
    Mod, mod, Module, Mult, Name, NameConstant, Nonlocal, Not, NotEq, NotIn,
    Num, operator, Or, Param, Pass, Pow, Raise, Return, RShift, Set, SetComp,
    Slice, slice, Starred, stmt, Store, Str, Sub, Subscript, Suite, Try, Tuple,
    UAdd, UnaryOp, unaryop, USub, While, With, withitem, Yield, YieldFrom
)

class NodeVisitor():
    def visit(self, node: AST) -> Any: ...
    def generic_visit(self, node: AST) -> None: ...

class NodeTransformer(NodeVisitor):
    def generic_visit(self, node: AST) -> None: ...

def parse(source: Union[str, bytes], filename: Union[str, bytes] = ..., mode: str = ...) -> AST: ...
def copy_location(new_node: AST, old_node: AST) -> AST: ...
def dump(node: AST, annotate_fields: bool = ..., include_attributes: bool = ...) -> str: ...
def fix_missing_locations(node: AST) -> AST: ...
def get_docstring(node: AST, clean: bool = ...) -> str: ...
def increment_lineno(node: AST, n: int = ...) -> AST: ...
def iter_child_nodes(node: AST) -> Iterator[AST]: ...
def iter_fields(node: AST) -> Iterator[typing.Tuple[str, Any]]: ...
def literal_eval(node_or_string: Union[str, AST]) -> Any: ...
def walk(node: AST) -> Iterator[AST]: ...

PyCF_ONLY_AST = ... # type: int

