!
!  Robust construction of a growth-curve.
!
!  Copyright © 2016 F.Hroch (hroch@physics.muni.cz)
!
!  This file is part of Munipack.
!
!  Munipack is free software: you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation, either version 3 of the License, or
!  (at your option) any later version.
!
!  Munipack is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.
!
!

module grow_model

  implicit none

  ! numerical precision of real numbers
  integer, parameter, private :: dbl = selected_real_kind(15)

contains


  subroutine growmodel(grows,dgrows,grow,dgrow)

    use robustmean

    real(dbl), dimension(:,:), intent(in) :: grows,dgrows
    real(dbl), dimension(:), intent(out) :: grow,dgrow
    real(dbl), dimension(:), allocatable :: f
    integer :: n,i,j,l,naper,nstars

    nstars = size(grows,1)
    naper = size(grows,2)

    ! initial estimate of growth curve as mean of all grow-curves
    do i = 1, naper
       call rmean(grows(:,i),grow(i),dgrow(i))
!       write(*,*) i,real(grow(i)),real(dgrow(i))
    end do


    allocate(f(naper*nstars))

    do i = 1,naper

       n = 0
       do l = 1, nstars
          do j = 1,naper
             n = n + 1
             f(n) = grows(l,i)/grows(l,j) * grow(j)
          end do
       end do
       if( n /= nstars*naper ) stop 'n /= nstars*naper'

       call rmean(f,grow(i),dgrow(i))

    end do

    deallocate(f)

    ! check for identical curves
    where( abs(dgrow) < epsilon(dgrow) )
       dgrow = 1e-5
    end where


  end subroutine growmodel


end module grow_model
