#!/bin/bash
#This tests comparison of angles
msort -j -q -l -w -c a < AngleTest01.data > AngleTest01.result
echo -n "AngleTest01			" >> TestResults;
if cmp -s AngleTest01.result AngleTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests case-folding in the ASCII range
msort -j -q -l -w -C < CaseFoldingTest01.data > CaseFoldingTest01.result
echo -n "CaseFoldingTest01		" >> TestResults;
if cmp -s CaseFoldingTest01.result CaseFoldingTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests case-folding in the Armenian range
msort -j -q -l -w -C < CaseFoldingTest02.data > CaseFoldingTest02.result
echo -n "CaseFoldingTest02		" >> TestResults;
if cmp -s CaseFoldingTest02.result CaseFoldingTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -B -l -d \t -e 13,13 -c l -e 9,12 -c n < CharacterRangeTest01.data > CharacterRangeTest01.result
echo -n "CharacterRangeTest01		" >> TestResults;
if cmp -s CharacterRangeTest01.result CharacterRangeTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -B -l -d \t -e 9,12 -c n -e 13,13 -c l < CharacterRangeTest02.data > CharacterRangeTest02.result
echo -n "CharacterRangeTest02		" >> TestResults;
if cmp -s CharacterRangeTest02.result CharacterRangeTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -B -l -d \t -e 13,13 -c l -i -e 1,8 -c l < CharacterRangeTest03.data > CharacterRangeTest03.result
echo -n "CharacterRangeTest03		" >> TestResults;
if cmp -s CharacterRangeTest03.result CharacterRangeTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -I -B -l -d \t -e 13,13 -c l -i -e 1,8 -c l < CharacterRangeTest04.data > CharacterRangeTest04.result
echo -n "CharacterRangeTest04		" >> TestResults;
if cmp -s CharacterRangeTest04.result CharacterRangeTest04.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the check only option.
echo -n "CheckOnlyTest01			" >> TestResults;
msort -j -q -l -w -c n -Q < CheckOnlyTest01A.data > CheckOnlyTest01A.result
rstat1=$?
cmp -s CheckOnlyTest01A.result CheckOnlyTest01.norm
cstat1=$?
msort -j -q -l -w -c n -Q < CheckOnlyTest01B.data > CheckOnlyTest01B.result
rstat2=$?
cmp -s CheckOnlyTest01B.result CheckOnlyTest01.norm
cstat2=$?
if [[($rstat1 == 0) && ($cstat1 == 0) && ($cstat2 == 0) && ($rstat2 > 0)]];
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests straight ASCII collating sequences.
msort -j -q -l -w -s CollatingSequenceTest01.ord < CollatingSequenceTest01.data > CollatingSequenceTest01.result
echo -n "CollatingSequenceTest01		" >> TestResults;
if cmp -s CollatingSequenceTest01.result CollatingSequenceTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests collating sequences containing non-ASCII characters.
msort -j -q -l -w -s CollatingSequenceTest02.ord < CollatingSequenceTest02.data > CollatingSequenceTest02.result
echo -n "CollatingSequenceTest02		" >> TestResults;
if cmp -s CollatingSequenceTest02.result CollatingSequenceTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests collating sequences containing non-ASCII characters and octal escapes.
msort -j -q -l -w -s CollatingSequenceTest03.ord < CollatingSequenceTest03.data > CollatingSequenceTest03.result
echo -n "CollatingSequenceTest03		" >> TestResults;
if cmp -s CollatingSequenceTest03.result CollatingSequenceTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests stripping of both diacritics and enclosures.
msort -j -q -l -w -T ed < ComboStrippingTest01.data > ComboStrippingTest01.result
echo -n "ComboStrippingTest01		" >> TestResults;
if cmp -s ComboStrippingTest01.result ComboStrippingTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of dates in which the month may be non-numerical.
msort -j -q -l -w -c d < DateTest01.data > DateTest01.result
echo -n "DateTest01			" >> TestResults;
if cmp -s DateTest01.result DateTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of dates in which the month may be non-numerical
#and the order of month names is specified in a sort order file.
msort -j -q -l -w -c d -s FrenchMonths.ord < DateTest02.data > DateTest02.result
echo -n "DateTest02			" >> TestResults;
if cmp -s DateTest02.result DateTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of dates using non-Western (Gurmukhi) numerals.
msort -j -q -l -w -c d < DateTest03.data > DateTest03.result
echo -n "DateTest03			" >> TestResults;
if cmp -s DateTest03.result DateTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of dates whose format is specified on the command line.
msort -j -q -l -w -c d -f m/d/y < DateTest04.data > DateTest04.result
echo -n "DateTest04			" >> TestResults;
if cmp -s DateTest04.result DateTest04.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of day-of-year dates using non-Western (Gurmukhi) numerals.
msort -j -q -l -w -c d -f y-d < DateTest05.data > DateTest05.result
echo -n "DateTest05			" >> TestResults;
if cmp -s DateTest05.result DateTest05.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests diacritic stripping
msort -j -q -l -w -T d < DiacriticStrippingTest01.data > DiacriticStrippingTest01.result
echo -n "DiacriticStrippingTest01	" >> TestResults;
if cmp -s DiacriticStrippingTest01.result DiacriticStrippingTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -l -n 1 -c D < DomainNameTest01.data > DomainNameTest01.result
echo -n "DomainNameTest01		" >> TestResults;
if cmp -s DomainNameTest01.norm DomainNameTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -l -n 1 -c D < EmailAddressTest01.data > EmailAddressTest01.result
echo -n "EmailAddressTest01		" >> TestResults;
if cmp -s EmailAddressTest01.norm EmailAddressTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests conversion of enclosed characters to their unenclosed counterparts.
msort -j -q -l -w -T e < EnclosureStrippingTest01.data > EnclosureStrippingTest01.result
echo -n "EnclosureStrippingTest01	" >> TestResults;
if cmp -s EnclosureStrippingTest01.norm EnclosureStrippingTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests exclusions specified on the command line
msort -j -q -l -w -c n -X '$C' < ExclusionCLITest01.data > ExclusionCLITest01.result
echo -n "ExclusionCLITest01		" >> TestResults;
if cmp -s ExclusionCLITest01.norm ExclusionCLITest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests exclusions specified in a file
msort -j -q -l -w -c n -x ExclusionFileTest01.exc < ExclusionFileTest01.data > ExclusionFileTest01.result
echo -n "ExclusionFileTest01		" >> TestResults;
if cmp -s ExclusionCLITest01.norm ExclusionCLITest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -l -n 1 -a M -A < FirstCharOnlyTest01.data > FirstCharOnlyTest01.result
echo -n "FirstCharOnlyTest01		" >> TestResults;
if cmp -s FirstCharOnlyTest01.norm FirstCharOnlyTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests parsing into fixed size records.
msort -j -q -O 36 -e 32,35 -c n < FixedSizeRecordTest01.data > FixedSizeRecordTest01.result
echo -n "FixedSizeRecordTest01		" >> TestResults;
if cmp -s FixedSizeRecordTest01.norm FixedSizeRecordTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests global inversion.
msort -j -q -l -w -I < GlobalInversionTest01.data > GlobalInversionTest01.result
echo -n "GlobalInversionTest01		" >> TestResults;
if cmp -s GlobalInversionTest01.result GlobalInversionTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests hybrid (lexical/numeric) comparison.
msort -j -q -l -w -c h < HybridComparisonTest01.data > HybridComparisonTest01.result
echo -n "HybridComparisonTest01		" >> TestResults;
if cmp -s HybridComparisonTest01.result HybridComparisonTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the command line flags for specifying input and output files.
msort -j -q -l -w -1 IOFlagTest01.data -2 IOFlagTest01.result
echo -n "IOFlagTest01			" >> TestResults;
if cmp -s IOFlagTest01.result IOFlagTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of ISO8601 date/time stamps without time zone offsets.
msort -j -q -l -w -c i < ISO8601DateTimeTest01.data > ISO8601DateTimeTest01.result
echo -n "ISO8601DateTimeTest01		" >> TestResults;
if cmp -s ISO8601DateTimeTest01.result ISO8601DateTimeTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of ISO8601 date/time stamps with time zone offsets.
msort -j -q -l -w -c i < ISO8601DateTimeTest02.data > ISO8601DateTimeTest02.result
echo -n "ISO8601DateTimeTest02		" >> TestResults;
if cmp -s ISO8601DateTimeTest02.result ISO8601DateTimeTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of ISO8601 date/time stamps with a leading sign.
msort -j -q -l -w -c i < ISO8601DateTimeTest03.data > ISO8601DateTimeTest03.result
echo -n "ISO8601DateTimeTest03		" >> TestResults;
if cmp -s ISO8601DateTimeTest03.result ISO8601DateTimeTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests handling of input data with CR rather than LF as line terminator.
msort -j -q -l -m -w < LineEndTest01.data > LineEndTest01.result
echo -n "LineEndTest01			" >> TestResults;
if cmp -s LineEndTest01.result LineEndTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests local inversion with a single key.
msort -j -q -l -w -i < LocalInversionTest01.data > LocalInversionTest01.result
echo -n "LocalInversionTest01		" >> TestResults;
if cmp -s LocalInversionTest01.result LocalInversionTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests local inversion with two keys.
msort -j -q -l -n 2 -c n -i -n 1 < LocalInversionTest02.data > LocalInversionTest02.result
echo -n "LocalInversionTest02		" >> TestResults;
if cmp -s LocalInversionTest02.result LocalInversionTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests handling of input lines thousands of lines longs
msort -j -q -l -w < LongLineTest01.data > LongLineTest01.result
echo -n "LongLineTest01			" >> TestResults;
if cmp -s LongLineTest01.result LongLineTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests month name sorting using an order defined in a file.
msort -j -q -l -n 1 -c m -s MonthNameTest02.ord -n 2 -c n < MonthNameTest02.data > MonthNameTest02.result
echo -n "MonthNameTest02			" >> TestResults;
if cmp -s MonthNameTest02.result MonthNameTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the ability to sort on non-Western numerals (Old Persian)
msort -j -q -l -w -c n -y Old_Persian < NumberTest01.data > NumberTest01.result
echo -n "NumberTest01			" >> TestResults;
if cmp -s NumberTest01.result NumberTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the ability to sort on numbers using different numeral systems in different fields.
msort -j -q -l -n 2 -c n -y Chinese -n 1 -c n -y Devanagari < NumberTest02.data > NumberTest02.result
echo -n "NumberTest02			" >> TestResults;
if cmp -s NumberTest02.result NumberTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the ability to sort on non-Western numbers (Roman numerals)
msort -j -q -l -w -c n -y Roman < NumberTest03.data > NumberTest03.result
echo -n "NumberTest03			" >> TestResults;
if cmp -s NumberTest03.result NumberTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the ability to sort on numbers in a bunch of different numeral systems
msort -j -q -l -w -c n -y all < NumberTest04.data > NumberTest04.result
echo -n "NumberTest04			" >> TestResults;
if cmp -s NumberTest04.result NumberTest04.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the ability to sort on numeric strings using non-Western numerals (Gurmukhi)
msort -j -q -l -w -c N -y Gurmukhi < NumericStringTest01.data > NumericStringTest01.result
echo -n "NumericStringTest01		" >> TestResults;
if cmp -s NumericStringTest01.result NumericStringTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the handling of optional tagged fields where the key is entirely absent.
msort -j -q -b -t '%P:' -o g < OptionalFieldTest01.data > OptionalFieldTest01.result
echo -n "OptionalFieldTest01		" >> TestResults;
if cmp -s OptionalFieldTest01.result OptionalFieldTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the handling of optional tagged fields where the tag is present by has no value.
msort -j -q -b -t '%P:' -o g < OptionalFieldTest02.data > OptionalFieldTest02.result
echo -n "OptionalFieldTest02		" >> TestResults;
if cmp -s OptionalFieldTest02.result OptionalFieldTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the handling of an optional positionally-defined field.
msort -j -q -l -n 2 -o l -n 1 < OptionalFieldTest03.data > OptionalFieldTest03.result
echo -n "OptionalFieldTest03		" >> TestResults;
if cmp -s OptionalFieldTest03.result OptionalFieldTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests a single positive field number.
msort -j -q -l -d ':' -n 3  -c n < PositionKeyTest01.data > PositionKeyTest01.result
echo -n "PositionKeyTest01		" >> TestResults;
if cmp -s PositionKeyTest01.norm PositionKeyTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests a single negative field number.
msort -j -q -l -d ':' -n -5 -c n < PositionKeyTest01.data > PositionKeyTest02.result
echo -n "PositionKeyTest02		" >> TestResults;
if cmp -s PositionKeyTest02.norm PositionKeyTest02.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests a single positive field number with character offset
msort -j -q -l -d ':' -n 3.2 -c n < PositionKeyTest01.data > PositionKeyTest03.result
echo -n "PositionKeyTest03		" >> TestResults;
if cmp -s PositionKeyTest03.norm PositionKeyTest03.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests a single negative field number with character offset
msort -j -q -l -d ':' -n -5.2 -c n < PositionKeyTest01.data > PositionKeyTest04.result
echo -n "PositionKeyTest04		" >> TestResults;
if cmp -s PositionKeyTest04.norm PositionKeyTest04.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests compound conditional keys, that is, composed of two or more fields.
msort -j -q -l -d ':' -n '1,2' -c n -X ':' < PositionKeyTest05.data > PositionKeyTest05.result
echo -n "PositionKeyTest05		" >> TestResults;
if cmp -s PositionKeyTest05.norm PositionKeyTest05.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests parsing on a specified record separator.
#We set the record-separator to semi-colon and the field separator to tab
#and sort numerically on the second field.
msort -j -q -r ';' -d '\t' -n 2 -c n < RecordSeparatorTest01.data > RecordSeparatorTest01.result
echo -n "RecordSeparatorTest01		" >> TestResults;
if cmp -s RecordSeparatorTest01.result RecordSeparatorTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests key reversal.
msort -j -q -l -n 1 -R < ReversalTest01.data > ReversalTest01.result
echo -n "ReversalTest01			" >> TestResults;
if cmp -s ReversalTest01.result ReversalTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests use of a sort order file with a non-default separator
msort -j -q -l -w -W SortOrderFileSeparatorTest01.sep -s SortOrderFileSeparatorTest01.ord < SortOrderFileSeparatorTest01.data > SortOrderFileSeparatorTest01.result
echo -n "SortOrderFileSeparatorTest01	" >> TestResults;
if cmp -s SortOrderFileSeparatorTest01.result SortOrderFileSeparatorTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests sorting on string length, with a secondary lexicographic sort.
msort -j -q -l -n 1 -c s -n 1 < StringLengthTest01.data > StringLengthTest01.result
echo -n "StringLengthTest01		" >> TestResults;
if cmp -s StringLengthTest01.result StringLengthTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests sorting on string length with multigraphs and a secondary lexicographic sort.
msort -j -q -l -n 1 -c s -s StringLengthTest02.ord -n 1 < StringLengthTest02.data > StringLengthTest02.result
echo -n "StringLengthTest02		" >> TestResults;
if cmp -s StringLengthTest02.result StringLengthTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -l -w -T s < StylisticTest01.data > StylisticTest01.result
echo -n "StylisticTest01			" >> TestResults;
if cmp -s StylisticTest01.result StylisticTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests substitions.
msort -j -q -l -w -S SubstitutionTest01.sub < SubstitutionTest01.data > SubstitutionTest01.result
echo -n "SubstitutionTest01		" >> TestResults;
if cmp -s SubstitutionTest01.result SubstitutionTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests fancy substitions.
msort -j -q -l -w -S SubstitutionTest02.sub < SubstitutionTest02.data > SubstitutionTest02.result
echo -n "SubstitutionTest02		" >> TestResults;
if cmp -s SubstitutionTest02.result SubstitutionTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests key selection by tag.
msort -j -q -t '%M:' -t '%P:' < TaggedKeyTest01.data > TaggedKeyTest01.result
echo -n "TaggedKeyTest01			" >> TestResults;
if cmp -s TaggedKeyTest01.result TaggedKeyTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests key selection by tags specified by means of a regular expression.
msort -j -q -t '%(M|D.*|d.*):' -t '%P:' < TaggedKeyTest02.data > TaggedKeyTest02.result
echo -n "TaggedKeyTest02			" >> TestResults;
if cmp -s TaggedKeyTest02.result TaggedKeyTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the handling of empty keys, that is, fields with a tag but no value.
msort -j -q -t '%G:' -t '%P:' < TaggedKeyTest03.data > TaggedKeyTest03.result
echo -n "TaggedKeyTest03			" >> TestResults;
if cmp -s TaggedKeyTest03.result TaggedKeyTest03.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of simple times, without time zone offsets
msort -j -q -l -w -c t < TimeTest01.data > TimeTest01.result
echo -n "TimeTest01			" >> TestResults;
if cmp -s TimeTest01.result TimeTest01.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the interpretation of times with ISO8601 time zone offsets.
msort -j -q -l -w -c t < TimeTest02.data > TimeTest02.result
echo -n "TimeTest02			" >> TestResults;
if cmp -s TimeTest02.result TimeTest02.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests Turkic case folding
msort -j -q -l -a m -n 1 -C -z -n 2 < TurkicCaseFoldTest.data > TurkicCaseFoldTest.result
echo -n "TurkicCaseFoldTest		" >> TestResults;
if cmp -s TurkicCaseFoldTest.result TurkicCaseFoldTest.norm
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests disabling of the default of normalization to NFC.
msort -j -q -l -n 1 -n 2 -c n -u n < UnicodeNormalizationTest01.data > UnicodeNormalizationTest01.result
echo -n "UnicodeNormalizationTest01	" >> TestResults;
if cmp -s UnicodeNormalizationTest01.norm UnicodeNormalizationTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests the default of normalization to NFC.
msort -j -q -l -n 1 -n 2 -c n -u c < UnicodeNormalizationTest02.data > UnicodeNormalizationTest02.result
echo -n "UnicodeNormalizationTest02	" >> TestResults;
if cmp -s UnicodeNormalizationTest02.norm UnicodeNormalizationTest02.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
#This tests normalization to NFD.
msort -j -q -l -n 1 -n 2 -c n -u d < UnicodeNormalizationTest03.data > UnicodeNormalizationTest03.result
echo -n "UnicodeNormalizationTest03	" >> TestResults;
if cmp -s UnicodeNormalizationTest03.norm UnicodeNormalizationTest03.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi
msort -j -q -l -n 1 -c D < URIWithSchemeTest01.data > URIWithSchemeTest01.result
echo -n "URIWithSchemeTest01		" >> TestResults;
if cmp -s URIWithSchemeTest01.norm URIWithSchemeTest01.result;
then echo "PASSED" >> TestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> TestResults;
fi




