#ifndef VOLUME_TXX
#define VOLUME_TXX

#include "Volume.h"

#include <numeric>
#include <algorithm>

namespace jcs {


template <class T> float 
Volume<T>::GetSpacing() 
{
	if (mSliceMap.size() < 2) return 1;
	typename std::map<float, std::vector<T> >::iterator it = begin();
	float pos1 = (*it).first;
	float pos2 = (*++it).first;
	return pos2 - pos1;
}

//template <class T> T
//Volume<T>::Max()
//{
//	typename std::map<float, std::vector<T> >::iterator it = mSliceMap.begin();
//	typename std::map<float, std::vector<T> >::iterator end = mSliceMap.end();
//	T vol_max = *std::max_element((*it).second.begin(), (*it).second.end());
//	while (++it != end) {
//		T slice_max = *std::max_element((*it).second.begin(), (*it).second.end());
//		vol_max = std::max<T>(vol_max, slice_max);
//	}
//	return vol_max;
//}
//
//template <class T> T
//Volume<T>::Min()
//{
//	typename std::map<float, std::vector<T> >::iterator it = mSliceMap.begin();
//	typename std::map<float, std::vector<T> >::iterator end = mSliceMap.end();
//	T vol_min = *std::min_element((*it).second.begin(), (*it).second.end());
//	while (++it != end) {
//		T slice_min = *std::max_element((*it).second.begin(), (*it).second.end());
//		vol_min = std::min<T>(vol_min, slice_min);
//	}
//	return vol_min;
//}

template <class T> int 
Volume<T>::NumLessThan(const T& value)
{
	typename std::map<float, std::vector<T> >::iterator it = mSliceMap.begin();
	typename std::map<float, std::vector<T> >::iterator end = mSliceMap.end();
	int count = 0;
	while (++it != end) {
		count += std::count_if((*it).second.begin(), (*it).second.end(),
			std::bind2nd(std::less<T>(), value));	
		++it;
	}
	return count;
}

// nb. I have code for a faster transpose for power of two square matrices
// if this is too slow
/*
void
Volume::mTranspose(const DataVector& original, DataVector& rotated)
{
	DataVector::const_iterator it;
	for (int i = 0; i < mRows; ++i) {
		for (it = original.begin(); it < original.end(); it += mColumns) {
			rotated.push_back(*(it + i));
		}
	}
	return;
} */

}

#endif
