/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Topology
implements DataIO {
    public static final int EVENT_ID = 0;
    public static final int STATE_ID = 1;
    public static final int ARROW_ID = 2;
    public static final Topology EVENT = new Topology(0);
    public static final Topology STATE = new Topology(1);
    public static final Topology ARROW = new Topology(2);
    private int index;

    public Topology(int n) {
        this.index = n;
    }

    public boolean equals(Topology topology) {
        return this.index == topology.index;
    }

    public boolean equals(Object object) {
        return this.equals((Topology)object);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean isEvent() {
        return this.index == 0;
    }

    public boolean isState() {
        return this.index == 1;
    }

    public boolean isArrow() {
        return this.index == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrimitive() {
        if (this.index == 1) return true;
        if (this.index == 2) return true;
        if (this.index != 0) return false;
        return true;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.index);
    }

    public Topology(DataInput dataInput) throws IOException {
        this.index = dataInput.readInt();
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.index = dataInput.readInt();
    }

    public String toString() {
        switch (this.index) {
            case 0: {
                return "Event";
            }
            case 1: {
                return "State";
            }
            case 2: {
                return "Arrow";
            }
        }
        return "Unknown";
    }
}

