/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Category;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import logformat.clogTOdrawable.InputLog;
import logformat.slog2.CategoryMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TraceName;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeTrunk;

public class ClogToSlog2 {
    private static short num_children_per_node = 0;
    private static int leaf_bytesize = 0;
    private static String in_filename;
    private static String out_filename;
    private static boolean enable_endtime_check;
    private static boolean continue_when_violation;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        Serializable serializable;
        Kind kind;
        double d = Double.NEGATIVE_INFINITY;
        out_filename = null;
        ClogToSlog2.parseCmdLineArgs(stringArray);
        if (out_filename == null) {
            out_filename = TraceName.getDefaultSLOG2Name(in_filename);
        }
        CategoryMap categoryMap = new CategoryMap();
        HashMap<Topology, Category> hashMap = new HashMap<Topology, Category>();
        long l = 0L;
        Date date = new Date();
        InputLog inputLog = new InputLog(in_filename);
        OutputLog outputLog = new OutputLog(out_filename);
        if (leaf_bytesize > 0) {
            outputLog.setTreeLeafByteSize(leaf_bytesize);
        }
        if (num_children_per_node > 0) {
            outputLog.setNumChildrenPerNode(num_children_per_node);
        }
        TreeTrunk treeTrunk = new TreeTrunk(outputLog, hashMap);
        Date date2 = new Date();
        while ((kind = inputLog.peekNextKind()) != Kind.EOF) {
            Category category;
            if (kind == Kind.TOPOLOGY) {
                Topology topology = inputLog.getNextTopology();
                category = Category.getShadowCategory(topology);
                categoryMap.put(new Integer(category.getIndex()), category);
                hashMap.put(topology, category);
                continue;
            }
            if (kind == Kind.CATEGORY) {
                category = inputLog.getNextCategory();
                categoryMap.put(new Integer(category.getIndex()), category);
                continue;
            }
            if (kind == Kind.PRIMITIVE) {
                Primitive primitive = inputLog.getNextPrimitive();
                primitive.resolveCategory(categoryMap);
                ++l;
                if (enable_endtime_check) {
                    double d2;
                    if (!primitive.isTimeOrdered()) {
                        System.out.println("**** Primitive Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (d > (d2 = primitive.getLatestTime())) {
                        System.err.println("***** Violation of Increasing Endtime Order! *****\n   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    d = d2;
                }
                treeTrunk.addDrawable(primitive);
                continue;
            }
            System.err.println("ClogToSlog2: Unrecognized return from peekNextKind() = " + kind);
        }
        if (treeTrunk.flushToFile()) {
            categoryMap.removeUnusedCategories();
            outputLog.writeCategoryMap(categoryMap);
            serializable = new LineIDMapList();
            ((ArrayList)serializable).add(treeTrunk.getIdentityLineIDMap());
            outputLog.writeLineIDMapList((LineIDMapList)serializable);
            outputLog.close();
            inputLog.close();
        } else {
            outputLog.close();
            inputLog.close();
            System.err.println("Error: No drawable is found in the trace " + in_filename);
            serializable = new File(out_filename);
            if (((File)serializable).isFile() && ((File)serializable).exists()) {
                System.err.println("       Removing the remnants of the file " + out_filename + " .....");
                ((File)serializable).delete();
            }
            System.exit(1);
        }
        serializable = new Date();
        System.out.println("\n");
        System.out.println("Number of Drawables = " + l);
        System.out.println("Number of Unmatched Events = " + inputLog.getNumberOfUnMatchedEvents());
        System.out.println("Total ByteSize of the logfile = " + inputLog.getTotalBytesRead());
        System.out.println("timeElapsed between 1 & 2 = " + (date2.getTime() - date.getTime()) + " msec");
        System.out.println("timeElapsed between 2 & 3 = " + (((Date)serializable).getTime() - date2.getTime()) + " msec");
    }

    private static int parseByteSize(String string) {
        int n = Math.max(string.indexOf(107), string.indexOf(75));
        int n2 = Math.max(string.indexOf(109), string.indexOf(77));
        if (n > 0) {
            return Integer.parseInt(string.substring(0, n)) * 1024;
        }
        if (n2 > 0) {
            return Integer.parseInt(string.substring(0, n2)) * 1024 * 1024;
        }
        return Integer.parseInt(string);
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        in_filename = null;
        enable_endtime_check = false;
        continue_when_violation = false;
        if (stringArray.length == 0) {
            System.out.println(help_msg);
            System.out.flush();
            System.exit(0);
        }
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    String string;
                    if (stringArray[n].equals("-h") || stringArray[n].equals("--h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-tc")) {
                        enable_endtime_check = true;
                        continue_when_violation = false;
                        stringBuffer.append("\n endtime_order_check_exit = true");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tcc")) {
                        enable_endtime_check = true;
                        continue_when_violation = true;
                        stringBuffer.append("\n endtime_order_check_stay = true");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-nc")) {
                        string = stringArray[++n];
                        num_children_per_node = Short.parseShort(string);
                        stringBuffer.append("\n number_of_children_per_node = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ls")) {
                        string = stringArray[++n];
                        leaf_bytesize = ClogToSlog2.parseByteSize(string);
                        stringBuffer.append("\n max_byte_size_of_leaf_node = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        out_filename = stringArray[++n].trim();
                        stringBuffer.append("\n output_filename = " + out_filename);
                        ++n;
                        if (out_filename.endsWith(".slog2")) continue;
                        System.err.println("Warning: The suffix of the output filename is NOT \".slog2\".");
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + ClogToSlog2.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + ClogToSlog2.indexOrderStr(n) + " command line argument.");
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + ClogToSlog2.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a CLOG filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        help_msg = "Usage: java slog2.output.Clog2Slog [options] clog_filename.\n options: \n\t [-h|--h|-help|--help]             \t Display this message.\n\t [-tc]                             \t Check increasing endtime order,\n\t                                   \t exit when 1st violation occurs.\n\t [-tcc]                            \t Check increasing endtime order,\n\t                                   \t continue when violations occur.\n\t [-nc number_of_children_per_node] \t Default value is 2.\n\t [-ls max_byte_size_of_leaf_node]  \t Default value is 65536.\n\t [-o output_filename_with_slog2_suffix]\n\n note: \"max_byte_size_of_leaf_node\" can be specified with suffix k, K, m or M,\n       where k or K stands for kilobyte, m or M stands for megabyte.\n       e.g. 64k means 65536 bytes.\n";
    }
}

