/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Drawable;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import viewer.timelines.InfoPanelForDrawable;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;

public class InfoDialogForDrawable
extends InfoDialog {
    private static final long serialVersionUID = 13200L;
    private ModelTime time_model;
    private double clk_time_pos;
    private JButton left_btn;
    private JButton home_btn;
    private JButton right_btn;

    public InfoDialogForDrawable(Frame frame, double d, Map map, String[] stringArray, ModelTime modelTime, final Drawable drawable) {
        super(frame, "Drawable Info Box", d);
        this.time_model = modelTime;
        this.clk_time_pos = d;
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(new InfoPanelForDrawable(map, stringArray, drawable));
        JPanel jPanel = super.getCloseButtonPanel();
        this.left_btn = new JButton("left");
        this.home_btn = new JButton("home");
        this.right_btn = new JButton("right");
        this.left_btn.setAlignmentX(0.0f);
        this.home_btn.setAlignmentX(0.0f);
        this.right_btn.setAlignmentX(1.0f);
        this.left_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = drawable.getStartVertex().time;
                InfoDialogForDrawable.this.time_model.centerTimeViewPosition(d);
            }
        });
        this.home_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialogForDrawable.this.time_model.centerTimeViewPosition(InfoDialogForDrawable.this.clk_time_pos);
            }
        });
        this.right_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = drawable.getFinalVertex().time;
                InfoDialogForDrawable.this.time_model.centerTimeViewPosition(d);
            }
        });
        jPanel.add(this.left_btn);
        jPanel.add(this.home_btn);
        jPanel.add(this.right_btn);
        container.add(jPanel);
    }
}

