//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QFile>
#include <QTextStream>
#include <QDir>
#include "specialcomboboxwidgets.h"

EncodingWidget::EncodingWidget(QString& type) {
	addItem(tr("West Europe") + " iso8859-1",type + "iso8859-1");
	addItem(tr("West Europe") + " iso8859-14",type + "iso8859-14");
	addItem(tr("West Europe") + " cp1252",type + "cp1252");
	addItem(tr("West Europe") + " iso8859-15",type + "iso8859-15");
	addItem(tr("Unicode") + " utf8",type + "utf8");
	addItem(tr("Unicode") + " ucs2",type + "ucs2");
	addItem(tr("Unicode") + " utf16",type + "utf16");
	addItem(tr("Unicode") + " utf7",type + "utf7");
	addItem(tr("Arabic") + " cp1256",type + "cp1256");
	addItem(tr("Arabic") + " iso8859-6",type + "iso8859-6");
	addItem(tr("Vietnamese") + " cp1258",type + "cp1258");
	addItem(tr("Greek") + " cp1253",type + "cp1253");
	addItem(tr("Greek") + " iso8859-7",type + "iso8859-7");
	addItem(tr("Ivrit") + " cp1255",type + "cp1255");
	addItem(tr("Ivrit") + " iso8859-8",type + "iso8859-8");
	addItem(tr("Cyrillics") + " cp1251",type + "cp1251");
	addItem(tr("Cyrillics") + " iso8859-5",type + "iso8859-5");
	addItem(tr("Cyrillics") + " koi8-r",type + "koi8-r");
	addItem(tr("Cyrillics") + " koi8-u",type + "koi8-u");
	addItem(tr("Chinese") + " gb18030",type + "gb18030");
	addItem(tr("Chinese") + " big5",type + "big5");
	addItem(tr("Chinese") + " big5-hkscs",type + "big5-hkscs");
	addItem(tr("Korean") + " euckr",type + "euckr");
	addItem(tr("Baltic states") + " cp1257",type + "cp1257");
	addItem(tr("Baltic states") + " iso8859-13",type + "iso8859-13");
	addItem(tr("Baltic states") + " iso8859-4",type + "iso8859-4");
	addItem(tr("Thai") + " cp874",type + "cp874");
	addItem(tr("Thai") + " iso8859-11",type + "iso8859-11");
	addItem(tr("Thai") + " tis620",type + "tis620");
	addItem(tr("Turkish") + " cp1254",type + "cp1254");
	addItem(tr("Turkish") + " iso8859-9",type + "iso8859-9");
	addItem(tr("Central Europe") + " cp1250",type + "cp1250");
	addItem(tr("Central Europe") + " ibm852",type + "ibm852");
	addItem(tr("Central Europe") + " iso8859-2",type + "iso8859-2");
	addItem(tr("Central Europe") + " iso8859-3",type + "iso8859-3");
	addItem(tr("Japan") + " eucjp",type + "eucjp");
	addItem(tr("Japan") + " jis7",type + "jis7");
	addItem(tr("Japan") + " sjis",type + "sjis");
}

CodepageWidget::CodepageWidget() {
	addItem("437 - " + tr("The original IBM PC code page"),"codepage=437");
	addItem("737 - " + tr("Greek"),"codepage=737");
	addItem("850 - " + tr("Multilingual (Latin-1)"),"codepage=850");
	addItem("852 - " + tr("Slavic (Latin-2)"),"codepage=852");
	addItem("855 - " + tr("Cyrillic"),"codepage=855");
	addItem("857 - " + tr("Turkish"),"codepage=857");
	addItem("858 - " + tr("\"Multilingual\" with euro symbol"),"codepage=858");
	addItem("860 - " + tr("Portuguese"),"codepage=860");
	addItem("861 - " + tr("Icelandic"),"codepage=861");
	addItem("863 - " + tr("French Canadian"),"codepage=863");
	addItem("865 - " + tr("Nordic"),"codepage=865");
	addItem("862 - " + tr("Hebrew"),"codepage=862");
	addItem("866 - " + tr("Cyrillic"),"codepage=866");
	addItem("869 - " + tr("Greek") + "2","codepage=869");
}

LocaleWidget::LocaleWidget() {
	addItem(tr("Default locale"),"default");
	QDir localeDir("/usr/lib/locale");
	foreach (QString localeName,localeDir.entryList(QDir::Dirs)) {
		if (localeName == "." || localeName == "..")
			continue;
		addItem(localeName,"locale=" + localeName);
	}
}

GIDWidget::GIDWidget() {
	addItem(tr("Current process"),"gid=0");

	QFile groupFile("/etc/group");
	groupFile.open(QIODevice::ReadOnly);
	QTextStream groupStream(&groupFile);

	while (!groupStream.atEnd()) {
		QString line = groupStream.readLine();
		if (line.isEmpty())
			continue;
		QStringList list = line.split(":");
		if (list.count() != 4)
			continue;
		addItem(list[0],"gid=" + list[2]); 
	}
}


UIDWidget::UIDWidget() {
	addItem(tr("Current process"),"uid=0");

	QFile groupFile("/etc/passwd");
	groupFile.open(QIODevice::ReadOnly);
	QTextStream groupStream(&groupFile);

	while (!groupStream.atEnd()) {
		QString line = groupStream.readLine();
		if (line.isEmpty())
			continue;
		QStringList list = line.split(":");
		if (list.count() != 7)
			continue;
		addItem(list[0],"uid=" + list[2]);
	}
}
