//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKHAL_H
#define DISKHAL_H

#include <QObject>
#include <QList>
#include "diskfstab.h"

class DiskDevice;
class QDBusInterface;

/*
Class duties:
	1. Receive information about devices
	2. Create DiskDevice objects and store them in devicesList
	3. Set parents and childs to received devices
	4. Signal about added or removed devices
	5. Support communication with Hal by D-Bus
*/

class DiskHal : public QObject, public DiskFstab
{
	Q_OBJECT
	private slots:
		void addDevice(const QString &deviceUdi);
		void removeDevice(const QString &deviceUdi);
	signals:
		void deviceAdded(DiskDevice *addedDevice);
		void deviceRemoved(DiskDevice *removedDevice);
	private:
		// With help of it we receive intormation about devices
		QDBusInterface *informationCenter;
		QList<DiskDevice *> devicesList;

		bool debug;
		
	public:
		DiskHal(bool debug = true,QObject *parent = 0);
		~DiskHal();

		// Return a count of devicesList
		int count();
		QList<DiskDevice *>& devices();
		DiskDevice* deviceByUdi(const QString& udi);
		DiskDevice* deviceByBlockName(const QString& blockName);
		DiskDevice* deviceByUuid(const QString& uuid);
};

#endif
