; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
; (pload "./defsSubst.scm")
; (pload "./omega.scm")
; (pload "./defsNT.scm")
; (pload "./defsAxiomsSpecial.scm")
; (pload "./defsAxioms.scm")
; (pload "./trivial.scm")
; (pload "./auxGlobal_SHORT.scm")
;
; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************


; ==================================
;  Section: Auxiliaries for Lemma 3
; ==================================
; contains all auxiliaries for Lemma 3

; Lemma: "SCrsExtCtx"
; -------------------
(add-global-assumption
 "SCrsExtCtx"
 (pf "all rhos,sigs,taus,as^,ss.
      SCrs sigs rhos as^ ss -> SCrs (sigs:+:taus) rhos as^  ss"))

; Lemma: "TypJAbsElim"
; --------------------
(add-global-assumption
 "TypJAbsElim"
 (pf "all rhos,rho,tau,r.
       TypJ rhos(Abs rho r)tau -> TypJ(rho::rhos)r(Typ(rho::rhos)r)"))

; Lemma: "TypJVarRef"
; -------------------
(add-global-assumption "TypJVarRef"
 (pf "all k,rhos,rho.
      TypJ rhos(Var k)rho -> rho=(k thof rhos)"))

; Lemma: "TypJAbsArrow"
; ---------------------
(add-global-assumption "TypJAbsArrow"
 (pf "all rhos,rho,tau,r.
       TypJ rhos(Abs rho r)tau ->
       tau=(rho to Typ(rho::rhos)r)"))

; Lemma: "LemmaThreeVar"
; ----------------------
(add-global-assumption
 "LemmaThreeVar"
 (pf "all sigs,rhos,as^,ss,k.
       SCrs sigs rhos as^ ss -> k<Lh rhos -> 
       SCr sigs(k thof rhos)(k thof as^)(k thof ss)"))

; Lemma: "TypJApp"
; ----------------
; auxiliary for LemmaThree

(add-global-assumption "TypJApp"
  (pf "all sig,rhos,r,s.
        TypJ rhos(r s)sig -> 
        Typ rhos r = (Typ rhos s to sig)"))


; Subsection: LemmaThreeAux1
; ==========================

; Lemma:  "LemmaThreeAux1"
; ------------------------
(add-global-assumption "LemmaThreeAux1"
  (pf "all rhos,sigs,rho,tau,r,ss.TypJ rhos(Abs rho r)tau ->
       ex as^  SCrs sigs rhos as^ ss -> 
       TypJ sigs(Sub(Abs rho r) (Wrap 0 ss))(rho to Typ(rho::rhos)r)"))
