/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/enumerator.h>
#include <messaging/parameter.h>
#include <messaging/plugin.h>
#include <messaging/variant.h>

#include "mock_connector.h"

extern "C" {
// Our test symbol, we have to declare it as visible as we want
// to emulate strict compiler settings with symbol visibility chosen
// as hidden by default.
__attribute__((visibility("default"))) int test_symbol()
{
    return 42;
}
}

messaging::Connector* MESSAGING_FW_CREATE_FUNCTION()
{
    return new testing::MockConnector();
}

void MESSAGING_FW_DESTROY_FUNCTION(messaging::Connector* p)
{
    delete static_cast<testing::MockConnector*>(p);
}
