/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MISSION_CONTROL_H_
#define TESTING_MISSION_CONTROL_H_

#include <core/posix/child_process.h>

namespace testing
{
namespace tp
{
/// @brief MissionControl takes care of starting and stopping an instance of telepathy's mission-control.
class MissionControl
{
public:
    /// @brief mc is the path to the mission-control executable.
    /// TODO(tvoss): Should probably be configurable via the build system but good enough for now.
    static constexpr const char* mc{"/usr/lib/telepathy/mission-control-5"};

    /// @brief Creates a new instance, starting up an instance of telepathy's mission-control.
    MissionControl(const std::chrono::milliseconds& grace = std::chrono::milliseconds{500});

    /// @brief Kills the mission control instance and waits for the child process.
    ~MissionControl();

private:
    core::posix::ChildProcess cp;
};
}
}

#endif  // TESTING_MISSION_CONTROL_H_
