/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtest/gtest.h>
#include <messaging/has_interfaces.h>
#include <messaging/interface.h>

#include <memory>

namespace testing
{
class TheBaseHasInterfaces : public messaging::HasInterfaces
{
public:
    virtual ~TheBaseHasInterfaces() = default;
};

class TheHasInterfaces : public TheBaseHasInterfaces
{

};

class TheBaseInterface : public messaging::Interface
{
public:
    virtual ~TheBaseInterface() = default;

};

class TheInterfaceClass : public TheBaseInterface
{

};
}

using namespace testing;

TEST(HasInterfaceTest, test_plug_and_get) {

    auto interface_class = std::make_shared<TheInterfaceClass>();

    TheHasInterfaces the_has_interfaces_object;
    the_has_interfaces_object.plug_interface(interface_class);

    auto recovered_interface = the_has_interfaces_object.interface<TheBaseInterface>();

    auto casted_interface = std::dynamic_pointer_cast<TheInterfaceClass>(recovered_interface);
    EXPECT_NE(casted_interface, nullptr);

    messaging::InterfacesSet interfaces_set = the_has_interfaces_object.interfaces();
    EXPECT_EQ(interfaces_set.size(), 1);
}
