/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_DBUS_MONITOR_H_
#define TESTING_DBUS_MONITOR_H_

#include <core/posix/child_process.h>

#include <iosfwd>
#include <string>
#include <thread>

namespace testing
{
/// @brief DBusMonitor runs an instance of dbus-monitor, redirecting
/// its output to a log file for post-mortem debugging purposes in testing.
class DBusMonitor
{
public:
    /// @brief dm is the path to the dbus-monitor executable.
    /// TODO(tvoss): Should probably be configurable at build time,
    /// but good enough for now.
    static constexpr const char* dm{"/usr/bin/dbus-monitor"};

    /// @brief Creates a new instance, pointing the monitor at the
    /// given bus address, redirecting the output of the monitor
    /// to the given destination.
    ///
    /// Note that the destination stream has to stay valid until after
    /// the dtor of this class has finished.
    DBusMonitor(const std::string& bus_address);

    /// @brief Shuts down operations and kills the dbus monitor
    /// process managed by this instance.
    ~DBusMonitor();

    /// @brief cout returns an istream for reading the output of the monitor.
    std::istream& cout();

private:
    core::posix::ChildProcess cp;
};
}

#endif  // TESTING_DBUS_MONITOR_H_
