/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/connector_factory_initializer.h>
#include <messaging/connector_factory.h>
#include <messaging/associative_dictionary.h>
#include <messaging/plugin_connector.h>

#include "test_data.h"

#include <gtest/gtest.h>

TEST(ConnectorFactoryInitializer, construction_destruction_works)
{
    messaging::ConnectorFactoryInitializer initializer;
    (void)initializer;
}

TEST(ConnectorFactoryInitializer, initialize_returns_valid_object)
{
    messaging::ConnectorFactoryInitializer initializer;
    EXPECT_NE(nullptr, initializer.initialize());
}

TEST(ConnectorFactoryInitializer, resulting_connector_factory_knows_about_plugin_connector)
{
    messaging::AssociativeDictionary<std::string, std::string> dict;
    // messaging::ConnectorFactory requires the path to a shared object.
    dict.set_value_for_key("PluginConnector::path", testing::dynamic_library_path());
    messaging::ConnectorFactoryInitializer initializer;
    auto cf = initializer.initialize();

    cf->create_instance_for_name(messaging::PluginConnector::Descriptor::name)(dict);
}
