/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_MOCK_CONNECTION_H_
#define TESTING_MOCK_CONNECTION_H_

#include <messaging/connection.h>
#include <messaging/messenger.h>
#include <messaging/presence_manager.h>
#include <messaging/group_starter.h>

#include <tests/mock_messenger.h>
#include <tests/mock_presence_manager.h>
#include <tests/mock_group_starter.h>

#include <gmock/gmock.h>


namespace testing
{
class MockConnection : public messaging::Connection
{
public:
    struct MockObserver : public messaging::Connection::Observer
    {
        MOCK_METHOD2(on_status_changed, void(messaging::Connection::Status, messaging::Connection::StatusChangedReason));
    };

    MockConnection(const std::shared_ptr<messaging::Connection::Observer>& connection_observer,
                   const std::shared_ptr<messaging::Messenger::Observer>& messenger_observer,
                   const std::shared_ptr<messaging::PresenceManager::Observer>& presence_observer);

    void announce_status_connected();

    MOCK_METHOD0(self_identifier, std::string());
    MOCK_METHOD0(presence_manager, std::shared_ptr<messaging::PresenceManager>());
    MOCK_METHOD0(messenger, std::shared_ptr<messaging::Messenger>());
    MOCK_METHOD0(group_starter, std::shared_ptr<messaging::GroupStarter>());
    MOCK_METHOD0(connect, void());
    MOCK_METHOD1(disconnect, void(StatusChangedReason));
    MOCK_METHOD1(normalize_identifier, std::string(const std::string&));
    MOCK_METHOD1(is_valid_identifier, bool(const std::string&));

private:
    std::shared_ptr<NiceMock<MockMessenger>> mock_messenger_;
    std::shared_ptr<NiceMock<MockPresenceManager>> mock_presence_manager_;
    std::shared_ptr<NiceMock<MockGroupStarter>> mock_group_starter_;

    void fake_connect();
    std::shared_ptr<messaging::PresenceManager> fake_presence_manager();
    std::shared_ptr<messaging::Messenger> fake_messenger();
    std::shared_ptr<messaging::GroupStarter> fake_group_starter();
};
}

#endif  // TESTING_MOCK_CONNECTION_H_
